/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sync.modular.ew;

import cn.stylefeng.roses.kernel.sync.core.util.CustomSpringContextHolder;
import cn.stylefeng.roses.kernel.sync.modular.ew.base.AbstractEntryWrapper;
import cn.stylefeng.roses.kernel.sync.modular.ra.AbstractRowDataAction;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.google.protobuf.ByteString;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowDataEntryWrapper
implements AbstractEntryWrapper {
    private static final Logger log = LoggerFactory.getLogger(RowDataEntryWrapper.class);

    @Override
    public void processEntrys(List<CanalEntry.Entry> entrys) {
        List<AbstractRowDataAction> rowDataProcessors = CustomSpringContextHolder.getBeanOfType(AbstractRowDataAction.class);
        if (rowDataProcessors == null || rowDataProcessors.size() == 0) {
            return;
        }
        for (CanalEntry.Entry entry : entrys) {
            if (entry.getEntryType() != CanalEntry.EntryType.ROWDATA) continue;
            CanalEntry.RowChange rowChage = null;
            try {
                rowChage = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
            }
            catch (Exception e) {
                throw new RuntimeException("parse event has an error , data:" + entry.toString(), e);
            }
            CanalEntry.EventType eventType = rowChage.getEventType();
            if (eventType == CanalEntry.EventType.QUERY || rowChage.getIsDdl()) continue;
            CanalEntry.Header header = entry.getHeader();
            String schemaName = header.getSchemaName();
            String tableName = header.getTableName();
            for (CanalEntry.RowData rowData : rowChage.getRowDatasList()) {
                for (AbstractRowDataAction rowDataProcessor : rowDataProcessors) {
                    if (!rowDataProcessor.matches(schemaName, tableName, eventType)) continue;
                    rowDataProcessor.doExecute(rowData);
                }
            }
        }
    }
}

