/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sync.core.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.otter.canal.protocol.CanalEntry;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeUtil {
    private static final Logger log = LoggerFactory.getLogger(TypeUtil.class);

    public static <T> T createModel(List<CanalEntry.Column> columns, Class<T> clazz) {
        try {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            for (CanalEntry.Column column : columns) {
                String mysqlType = column.getMysqlType();
                String name = column.getName();
                String value = column.getValue();
                if (!StrUtil.isNotBlank((CharSequence)value)) continue;
                if (mysqlType.toLowerCase().contains("int")) {
                    attrs.put(name, Integer.valueOf(value));
                    continue;
                }
                if (mysqlType.toLowerCase().contains("long")) {
                    attrs.put(name, Integer.valueOf(value));
                    continue;
                }
                if (mysqlType.toLowerCase().contains("bigint")) {
                    attrs.put(name, Long.valueOf(value));
                    continue;
                }
                if (mysqlType.toLowerCase().contains("char")) {
                    attrs.put(name, value);
                    continue;
                }
                if (mysqlType.toLowerCase().contains("varchar")) {
                    attrs.put(name, value);
                    continue;
                }
                if (mysqlType.toLowerCase().contains("date")) {
                    attrs.put(name, DateUtil.parseDateTime((String)value).toJdkDate());
                    continue;
                }
                if (!mysqlType.toLowerCase().contains("text")) continue;
                attrs.put(name, value);
            }
            return (T)BeanUtil.mapToBean(attrs, clazz, (boolean)true);
        }
        catch (Exception e) {
            log.error("\u7c7b\u578b\u8f6c\u5316\u9519\u8bef\uff01", (Throwable)e);
            return null;
        }
    }
}

