/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.db.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.exception.LogException;
import cn.stylefeng.roses.kernel.log.api.exception.enums.LogExceptionEnum;
import cn.stylefeng.roses.kernel.log.api.pojo.manage.LogManagerRequest;
import cn.stylefeng.roses.kernel.log.db.entity.SysLog;
import cn.stylefeng.roses.kernel.log.db.mapper.SysLogMapper;
import cn.stylefeng.roses.kernel.log.db.service.SysLogService;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysLogServiceImpl
extends ServiceImpl<SysLogMapper, SysLog>
implements SysLogService {
    @Override
    public void add(LogManagerRequest logManagerRequest) {
        SysLog sysLog = new SysLog();
        BeanUtil.copyProperties((Object)logManagerRequest, (Object)((Object)sysLog), (String[])new String[0]);
        this.save((Object)sysLog);
    }

    @Override
    public void del(LogManagerRequest logManagerRequest) {
        SysLog sysLog = this.querySysLogById(logManagerRequest);
        this.removeById(sysLog.getLogId());
    }

    @Override
    public void delAll(LogManagerRequest logManagerRequest) {
        LambdaUpdateWrapper queryWrapper = new LambdaUpdateWrapper();
        queryWrapper.between(BaseEntity::getCreateTime, (Object)(logManagerRequest.getBeginDate() + " 00:00:00"), (Object)(logManagerRequest.getEndDate() + " 23:59:59"));
        queryWrapper.eq(SysLog::getAppName, (Object)logManagerRequest.getAppName());
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public SysLog detail(LogManagerRequest logManagerRequest) {
        LambdaQueryWrapper<SysLog> queryWrapper = this.createWrapper(logManagerRequest);
        return (SysLog)((Object)this.getOne((Wrapper)queryWrapper, false));
    }

    @Override
    public List<SysLog> findList(LogManagerRequest logManagerRequest) {
        LambdaQueryWrapper<SysLog> wrapper = this.createWrapper(logManagerRequest);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public PageResult<SysLog> findPage(LogManagerRequest logManagerRequest) {
        LambdaQueryWrapper<SysLog> wrapper = this.createWrapper(logManagerRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    private SysLog querySysLogById(LogManagerRequest logManagerRequest) {
        SysLog sysLog = (SysLog)((Object)this.getById(logManagerRequest.getLogId()));
        if (sysLog == null) {
            throw new LogException((AbstractExceptionEnum)LogExceptionEnum.LOG_NOT_EXISTED, new Object[]{logManagerRequest.getLogId()});
        }
        return sysLog;
    }

    private LambdaQueryWrapper<SysLog> createWrapper(LogManagerRequest logManagerRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        if (ObjectUtil.isEmpty((Object)logManagerRequest)) {
            return queryWrapper;
        }
        String beginDateTime = logManagerRequest.getBeginDate();
        String endDateTime = logManagerRequest.getEndDate();
        Date beginDate = null;
        Date endDate = null;
        if (StrUtil.isNotBlank((CharSequence)beginDateTime)) {
            beginDate = DateUtil.parseDateTime((CharSequence)(beginDateTime + " 00:00:00")).toJdkDate();
        }
        if (StrUtil.isNotBlank((CharSequence)endDateTime)) {
            endDate = DateUtil.parseDateTime((CharSequence)(endDateTime + " 23:59:59")).toJdkDate();
        }
        String name = logManagerRequest.getLogName();
        String appName = logManagerRequest.getAppName();
        String serverIp = logManagerRequest.getServerIp();
        Long userId = logManagerRequest.getUserId();
        String clientIp = logManagerRequest.getClientIp();
        String url = logManagerRequest.getRequestUrl();
        Long logId = logManagerRequest.getLogId();
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)logId), SysLog::getLogId, (Object)logId);
        queryWrapper.between(ObjectUtil.isAllNotEmpty((Object[])new Object[]{beginDate, endDate}), BaseEntity::getCreateTime, (Object)beginDate, (Object)endDate);
        queryWrapper.like(StrUtil.isNotEmpty((CharSequence)name), SysLog::getLogName, (Object)name);
        queryWrapper.like(StrUtil.isNotEmpty((CharSequence)appName), SysLog::getAppName, (Object)appName);
        queryWrapper.like(StrUtil.isNotEmpty((CharSequence)serverIp), SysLog::getServerIp, (Object)serverIp);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userId), SysLog::getUserId, (Object)userId);
        queryWrapper.eq(StrUtil.isNotEmpty((CharSequence)clientIp), SysLog::getClientIp, (Object)clientIp);
        queryWrapper.eq(StrUtil.isNotEmpty((CharSequence)url), SysLog::getRequestUrl, (Object)url);
        return queryWrapper;
    }
}

