/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.migration.web.controller;

import cn.stylefeng.roses.kernel.migration.api.pojo.MigrationAggregationPOJO;
import cn.stylefeng.roses.kernel.migration.web.pojo.MigrationRequest;
import cn.stylefeng.roses.kernel.migration.web.service.MigrationService;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@ApiResource(name="\u6570\u636e\u8fc1\u79fb\u63a7\u5236\u5668")
public class MigrationController {
    @Autowired
    private MigrationService migrationService;

    @GetResource(name="\u83b7\u53d6\u6240\u6709\u53ef\u5907\u4efd\u6570\u636e\u5217\u8868", path={"/dataMigration/getAllMigrationList"})
    public ResponseData getAllMigrationList() {
        List<MigrationRequest> migrationRequestList = this.migrationService.getAllMigrationList();
        return new SuccessResponseData(migrationRequestList);
    }

    @GetResource(name="\u5907\u4efd\u6307\u5b9a\u6570\u636e\u5217\u8868", path={"/dataMigration/migrationSelectData"})
    public ResponseData migrationSelectData(@Validated(value={MigrationAggregationPOJO.export.class}) MigrationAggregationPOJO migrationAggregationPOJO) {
        ArrayList<String> res = new ArrayList<String>();
        for (String s : migrationAggregationPOJO.getAppAndModuleNameList()) {
            try {
                String decode = URLDecoder.decode(s, "UTF-8");
                res.add(decode);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        migrationAggregationPOJO.setAppAndModuleNameList(res);
        String migrationSelectDataStr = this.migrationService.migrationSelectData(migrationAggregationPOJO);
        return new SuccessResponseData((Object)migrationSelectDataStr);
    }

    @PostResource(name="\u6062\u590d\u5907\u4efd\u6570\u636e", path={"/dataMigration/restoreData"})
    public ResponseData restoreData(@RequestPart(value="file") MultipartFile file, String type) {
        this.migrationService.restoreData(file, type);
        return new SuccessResponseData();
    }
}

