/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.migration.web.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.migration.aggregation.scheduling.SchedulingCenter;
import cn.stylefeng.roses.kernel.migration.api.pojo.MigrationAggregationPOJO;
import cn.stylefeng.roses.kernel.migration.web.pojo.MigrationRequest;
import cn.stylefeng.roses.kernel.migration.web.service.MigrationService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MigrationServiceImpl
implements MigrationService {
    @Override
    public List<MigrationRequest> getAllMigrationList() {
        HashMap<String, MigrationRequest> migrationRequestList = new HashMap<String, MigrationRequest>();
        List allMigrationInfo = SchedulingCenter.getAllMigrationInfo();
        for (String migration : allMigrationInfo) {
            List<String> moduleNames;
            String[] appAndModuleName = migration.split("#");
            String appName = appAndModuleName[0];
            String moduleName = appAndModuleName[1];
            MigrationRequest migrationRequest = (MigrationRequest)migrationRequestList.get(appName);
            if (ObjectUtil.isEmpty((Object)migrationRequest)) {
                migrationRequest = new MigrationRequest();
                migrationRequest.setAppName(appName);
                migrationRequestList.put(appName, migrationRequest);
            }
            if (ObjectUtil.isEmpty(moduleNames = migrationRequest.getModuleNames())) {
                moduleNames = new ArrayList<String>();
                migrationRequest.setModuleNames(moduleNames);
            }
            moduleNames.add(moduleName);
        }
        return new ArrayList<MigrationRequest>(migrationRequestList.values());
    }

    @Override
    public String migrationSelectData(MigrationAggregationPOJO migrationAggregationPOJO) {
        SchedulingCenter.exportData((MigrationAggregationPOJO)migrationAggregationPOJO);
        return JSONObject.toJSONString((Object)migrationAggregationPOJO);
    }

    @Override
    public void restoreData(MultipartFile file, String type) {
        String jsonStr = null;
        try {
            jsonStr = new String(file.getBytes(), StandardCharsets.UTF_8);
            MigrationAggregationPOJO migrationAggregationPOJO = (MigrationAggregationPOJO)JSON.parseObject((String)jsonStr, MigrationAggregationPOJO.class);
            SchedulingCenter.importData((MigrationAggregationPOJO)migrationAggregationPOJO, (String)type);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

