/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.mongodb.file.service.impl;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.IdUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.mongodb.api.MongoFileApi;
import cn.stylefeng.roses.kernel.mongodb.file.entity.MongoFileEntity;
import cn.stylefeng.roses.kernel.mongodb.file.mapper.MongoFileMapper;
import cn.stylefeng.roses.kernel.mongodb.file.service.MongoFileService;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MongoFileServiceImpl
implements MongoFileService,
MongoFileApi<MongoFileEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(MongoFileServiceImpl.class);
    @Resource
    private MongoFileMapper mongoFileMapper;
    @Resource
    private GridFsTemplate gridFsTemplate;
    @Resource
    private GridFSBucket gridFSBucket;

    @Override
    public MongoFileEntity saveFile(MultipartFile file) {
        MongoFileEntity fileDocument = new MongoFileEntity();
        fileDocument.setName(file.getOriginalFilename());
        fileDocument.setUploadDate(new Date());
        try {
            LoginUser loginUser = LoginContext.me().getLoginUser();
            fileDocument.setUploadUserId(loginUser.getUserId());
        }
        catch (Exception loginUser) {
            // empty catch block
        }
        fileDocument.setSuffix(file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".")));
        try {
            ObjectId store = this.gridFsTemplate.store(file.getInputStream(), IdUtil.simpleUUID(), file.getContentType());
            fileDocument.setGridfsId(String.valueOf(store));
            return (MongoFileEntity)((Object)this.mongoFileMapper.save((Object)fileDocument));
        }
        catch (IOException ex) {
            log.error(ex.getMessage());
            return fileDocument;
        }
    }

    @Override
    public void removeFile(String id) {
        Optional fileDocumentOptional = this.mongoFileMapper.findById(id);
        if (fileDocumentOptional.isPresent()) {
            this.mongoFileMapper.deleteById(id);
            this.gridFsTemplate.delete(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)((MongoFileEntity)((Object)fileDocumentOptional.get())).getGridfsId())));
        }
    }

    @Override
    public Optional<MongoFileEntity> getFileById(String id) {
        Optional fileDocumentOptional = this.mongoFileMapper.findById(id);
        if (fileDocumentOptional.isPresent()) {
            MongoFileEntity fileDocument = (MongoFileEntity)((Object)fileDocumentOptional.get());
            Query gridQuery = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)fileDocument.getGridfsId()));
            GridFSFile fsFile = this.gridFsTemplate.findOne(gridQuery);
            GridFSDownloadStream in = this.gridFSBucket.openDownloadStream(fsFile.getObjectId());
            try {
                if (in.getGridFSFile().getLength() > 0L) {
                    GridFsResource resource = new GridFsResource(fsFile, (InputStream)in);
                    fileDocument.setContent(IoUtil.readBytes((InputStream)resource.getInputStream()));
                    return Optional.of(fileDocument);
                }
                return Optional.empty();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return Optional.empty();
    }

    @Override
    public PageResult<MongoFileEntity> getFilesByPage(MongoFileEntity fileDocument) {
        Integer pageIndex = fileDocument.getPageNo();
        Integer pageSize = fileDocument.getPageSize();
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"uploadDate"});
        PageRequest pageRequest = PageRequest.of((int)(pageIndex - 1), (int)pageSize, (Sort)sort);
        Example example = Example.of((Object)((Object)fileDocument), (ExampleMatcher)ExampleMatcher.matching().withIgnoreCase(true).withIgnorePaths(new String[]{"_class", "pageSize", "pageNo", "content"}));
        Page all = this.mongoFileMapper.findAll(example, (Pageable)pageRequest);
        return PageResultFactory.createPageResult((List)all.getContent(), (Long)this.mongoFileMapper.count(example), (Integer)pageSize, (Integer)pageIndex);
    }
}

