/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.monitor.integration.controller;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.monitor.api.PrometheusApi;
import cn.stylefeng.roses.kernel.monitor.api.pojo.prometheus.PromResultInfo;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@ApiResource(name="\u6765\u81eaprometheus\u7684\u76d1\u63a7")
public class PrometheusMonitorController {
    @Value(value="${spring.application.name}")
    private String name;
    @Value(value="${prometheus.url}")
    private String prometheusUrl;
    @Value(value="${prometheus.instance}")
    private String prometheusInstance;
    @Resource
    private PrometheusApi service;

    @GetResource(name="tomcat\u76d1\u63a7\u9996\u9875", path={"/view/monitor/tomcatInfo"})
    public String tomcatIndex() {
        return "/modular/system/monitor/tomcatInfo.html";
    }

    @GetResource(name="tomcat\u76d1\u63a7\u6570\u636e", path={"/view/monitor/getTomcatInfo"})
    @ResponseBody
    public String tomcatInfo() {
        Map<String, Object> metricMap = this.getMetricInfos(this.getPromQl(), "tomcat_", "", "");
        return JSON.toJSONString(metricMap);
    }

    @GetResource(name="jvm\u76d1\u63a7\u9875\u9762", path={"/view/monitor/jvmInfo"})
    public String jvmIndex() {
        return "/modular/system/monitor/jvmInfo.html";
    }

    @GetResource(name="jvm\u76d1\u63a7\u6570\u636e", path={"/view/monitor/getJvmInfo"})
    @ResponseBody
    public String jvmInfo(@RequestParam(value="id", required=false) String id, @RequestParam(value="area", required=false) String area) {
        Map<String, Object> metricMap = this.getMetricInfos(this.getPromQl(id, area), "jvm_", "", "");
        return JSON.toJSONString(metricMap);
    }

    @GetResource(name="\u6027\u80fd\u76d1\u63a7\u9875\u9762", path={"/view/monitor/performanceInfo"})
    public String performanceIndex() {
        return "/modular/system/monitor/performanceInfo.html";
    }

    @GetResource(name="CPU\u76d1\u63a7\u6570\u636e", path={"/view/monitor/getCpuInfo"})
    @ResponseBody
    public String cpuInfo() {
        Map<String, Object> metricMap = this.getMetricInfos(this.getPromQl(), "cpu_", "", "");
        return JSON.toJSONString(metricMap);
    }

    @GetResource(name="\u670d\u52a1\u5668\u8d1f\u8f7d\u76d1\u63a7\u6570\u636e", path={"/view/monitor/getLoadInfo"})
    @ResponseBody
    public String loadInfo() {
        Map<String, Object> metricMap = this.getMetricInfos(this.getPromQl(), "system_", "", "");
        return JSON.toJSONString(metricMap);
    }

    @GetResource(name="\u8fdb\u7a0b\u76d1\u63a7\u6570\u636e", path={"/view/monitor/getProcessInfo"})
    @ResponseBody
    public String processInfo() {
        Map<String, Object> metricMap = this.getMetricInfos(this.getPromQl(), "process_", "", "");
        return JSON.toJSONString(metricMap);
    }

    @GetResource(name="\u65e5\u5fd7\u76d1\u63a7\u9875\u9762", path={"/view/monitor/logbackInfo"})
    public String logbackIndex() {
        return "/modular/system/monitor/logbackInfo.html";
    }

    @GetResource(name="\u65e5\u5fd7\u76d1\u63a7\u6570\u636e", path={"/view/monitor/getLogbackInfo"})
    @ResponseBody
    public String logbackInfo(@RequestParam(value="level") String level, @RequestParam(value="timeInterval") String timeInterval, @RequestParam(value="isRate") String isRate, @RequestParam(value="rateMetric") String rateMetric) {
        if (StrUtil.isEmpty((CharSequence)timeInterval)) {
            timeInterval = "[5m]";
        }
        Map<String, Object> metricMap = this.getMetricInfos(this.getIratePromQl(level, timeInterval), "logback_", isRate, rateMetric);
        return JSON.toJSONString(metricMap);
    }

    private String getPromQl(String id, String area) {
        StringBuilder promql = new StringBuilder("{application=\"");
        promql.append(this.name);
        if (!StrUtil.isEmpty((CharSequence)id)) {
            promql.append("\",id=\"");
            promql.append(id);
        }
        if (!StrUtil.isEmpty((CharSequence)area)) {
            promql.append("\",area=\"");
            promql.append(area);
        }
        if (!StrUtil.isEmpty((CharSequence)this.prometheusInstance)) {
            promql.append("\",instance=\"");
            promql.append(this.prometheusInstance);
        }
        promql.append("\"}");
        return promql.toString();
    }

    private String getPromQl() {
        StringBuilder promql = new StringBuilder("{application=\"");
        promql.append(this.name);
        if (!StrUtil.isEmpty((CharSequence)this.prometheusInstance)) {
            promql.append("\",instance=\"");
            promql.append(this.prometheusInstance);
        }
        promql.append("\"}");
        return promql.toString();
    }

    private String getIratePromQl(String level, String timeInterval) {
        StringBuilder promql = new StringBuilder("{application=\"");
        promql.append(this.name);
        if (!StrUtil.isEmpty((CharSequence)this.prometheusInstance)) {
            promql.append("\",instance=\"");
            promql.append(this.prometheusInstance);
        }
        if (!StrUtil.isEmpty((CharSequence)level)) {
            promql.append("\",level=\"");
            promql.append(level);
        }
        promql.append("\"}");
        promql.append(timeInterval);
        return promql.toString();
    }

    private Map<String, Object> getMetricInfos(String promQL, String metric, String isRate, String rateMetric) {
        HashMap<String, Object> metricMap = new HashMap<String, Object>();
        if (!StrUtil.isEmpty((CharSequence)this.prometheusUrl)) {
            List promResultInfos = this.service.getMetricInfo(this.prometheusUrl.concat("query_range"), promQL, isRate, rateMetric);
            if (Objects.isNull(promResultInfos)) {
                return metricMap;
            }
            for (PromResultInfo promResultInfo : promResultInfos) {
                String metricName = promResultInfo.getMetric().get__name__();
                JSONArray valueArray = JSONArray.parseArray((String)JSON.toJSONString((Object)promResultInfo.getValues()).replaceAll("\\\\", "").replace("\"", ""));
                if (!StrUtil.isEmpty((CharSequence)metricName)) {
                    if (!metricName.contains(metric)) continue;
                    metricMap.put(metricName, valueArray);
                    continue;
                }
                metricMap.put(rateMetric, valueArray);
            }
        }
        return metricMap;
    }
}

