/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.springdoc.converter;

import cn.stylefeng.roses.kernel.rule.annotation.ChineseDescription;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Objects;

public class GunsModelConverterImpl
implements ModelConverter {
    public Schema resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Schema schema = this.next(annotatedType, context, chain);
        Annotation[] ctxAnnotations = annotatedType.getCtxAnnotations();
        if (Objects.isNull(ctxAnnotations)) {
            return schema;
        }
        ChineseDescription chineseDescription = null;
        for (Annotation ctxAnnotation : ctxAnnotations) {
            if (!(ctxAnnotation instanceof ChineseDescription)) continue;
            chineseDescription = (ChineseDescription)ctxAnnotation;
            break;
        }
        if (chineseDescription == null) {
            return schema;
        }
        if (schema != null) {
            schema.setDescription(chineseDescription.value());
        }
        return schema;
    }

    private Schema next(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolve(annotatedType, context, chain);
        }
        return null;
    }
}

