/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.factory;

import cn.stylefeng.roses.kernel.scanner.api.constants.ScannerConstants;
import cn.stylefeng.roses.kernel.scanner.api.context.MetadataContext;
import cn.stylefeng.roses.kernel.scanner.api.enums.FieldTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import cn.stylefeng.roses.kernel.scanner.api.util.ClassDescriptionUtil;
import cn.stylefeng.roses.kernel.scanner.api.util.ClassTypeUtil;
import cn.stylefeng.roses.kernel.scanner.api.util.FieldDescriptionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDetailMetadataFactory {
    private static final Logger log = LoggerFactory.getLogger(ClassDetailMetadataFactory.class);

    public static Set<FieldMetadata> createFieldDetailMetadataSet(Type fieldType, String uuid) {
        FieldTypeEnum classFieldType = ClassTypeUtil.getClassFieldType(fieldType);
        Set<Object> fieldMetadata = null;
        switch (classFieldType) {
            case BASIC: {
                fieldMetadata = null;
                break;
            }
            case BASE_ARRAY: {
                Class baseArrayFieldClazz = (Class)fieldType;
                Class<?> baseArrayComponentType = baseArrayFieldClazz.getComponentType();
                FieldMetadata baseMetadata = ClassDescriptionUtil.createClassMetadata(baseArrayComponentType, FieldTypeEnum.BASIC, uuid);
                fieldMetadata = new LinkedHashSet();
                fieldMetadata.add(baseMetadata);
                break;
            }
            case ARRAY_WITH_OBJECT: {
                Class objArrayClass = (Class)fieldType;
                Class<?> objArrayComponentType = objArrayClass.getComponentType();
                fieldMetadata = ClassDetailMetadataFactory.createFieldDetailMetadataSet(objArrayComponentType, uuid);
                break;
            }
            case BASE_COLLECTION: {
                FieldMetadata collectionFieldMetadata = ClassDescriptionUtil.createClassMetadata(Object.class, FieldTypeEnum.OBJECT, uuid);
                fieldMetadata = new LinkedHashSet();
                fieldMetadata.add(collectionFieldMetadata);
                break;
            }
            case COLLECTION_WITH_OBJECT: {
                ParameterizedType collectionParameterizedType = (ParameterizedType)fieldType;
                Type[] actualTypeArguments = collectionParameterizedType.getActualTypeArguments();
                fieldMetadata = ClassDetailMetadataFactory.createFieldDetailMetadataSet(actualTypeArguments[0], uuid);
                break;
            }
            case OBJECT: {
                Class objectClass = (Class)fieldType;
                Field[] fields = objectClass.getDeclaredFields();
                fieldMetadata = new LinkedHashSet();
                MetadataContext.addClassRecord(uuid, objectClass.getName());
                for (Field field : fields) {
                    if (ScannerConstants.DONT_PARSE_FIELD.contains(field.getName())) continue;
                    FieldMetadata fieldInfo = MetadataContext.ensureFieldClassHaveParse(uuid, field.getGenericType()) ? FieldDescriptionUtil.createBasicMetadata(field, uuid) : FieldDescriptionUtil.createFieldMetadata(field, uuid);
                    fieldMetadata.add(fieldInfo);
                }
                break;
            }
            case OBJECT_WITH_GENERIC: {
                ParameterizedType objWithGenericParameterizedType = (ParameterizedType)fieldType;
                Type rawType = objWithGenericParameterizedType.getRawType();
                Type genericType = objWithGenericParameterizedType.getActualTypeArguments()[0];
                String totalName = fieldType.getTypeName() + genericType.getTypeName();
                if (MetadataContext.ensureFieldClassHaveParse(uuid, totalName)) {
                    return null;
                }
                MetadataContext.addClassRecord(uuid, totalName);
                fieldMetadata = ClassDetailMetadataFactory.getEntityWithGenericFieldMetadataList(rawType, genericType, uuid);
            }
        }
        return fieldMetadata;
    }

    public static Set<FieldMetadata> getEntityWithGenericFieldMetadataList(Type fieldType, Type genericType, String uuid) {
        if (fieldType instanceof Class) {
            Class clazz = (Class)fieldType;
            Set<FieldMetadata> fieldDetailMetadataSet = ClassDetailMetadataFactory.createFieldDetailMetadataSet(clazz, uuid);
            if (fieldDetailMetadataSet == null) {
                return null;
            }
            for (FieldMetadata fieldMetadata : fieldDetailMetadataSet) {
                if (FieldTypeEnum.COLLECTION_WITH_OBJECT.getCode().equals(fieldMetadata.getFieldType()) || FieldTypeEnum.WITH_UNKNOWN_GENERIC.getCode().equals(fieldMetadata.getFieldType())) {
                    fieldMetadata.setGenericFieldMetadata(ClassDetailMetadataFactory.createFieldDetailMetadataSet(genericType, uuid));
                } else if (FieldTypeEnum.OBJECT_WITH_GENERIC.getCode().equals(fieldMetadata.getFieldType())) {
                    Set<FieldMetadata> current = null;
                    try {
                        current = ClassDetailMetadataFactory.getEntityWithGenericFieldMetadataList(Class.forName(fieldMetadata.getFieldClassPath()), genericType, uuid);
                    }
                    catch (ClassNotFoundException e) {
                        log.error("\u7c7b\u65e0\u6cd5\u627e\u5230" + fieldMetadata.getFieldClassPath(), (Throwable)e);
                        continue;
                    }
                    fieldMetadata.setGenericFieldMetadata(current);
                }
                if (!FieldTypeEnum.WITH_UNKNOWN_GENERIC.getCode().equals(fieldMetadata.getFieldType())) continue;
                FieldTypeEnum classFieldType = ClassTypeUtil.getClassFieldType(genericType);
                fieldMetadata.setFieldType(classFieldType.getCode());
            }
            return fieldDetailMetadataSet;
        }
        log.debug("\u5e26\u6cdb\u578b\u7684\u5b9e\u4f53\u4e3b\u9898rawType\u975eClass\u7c7b\u578b" + fieldType);
        return null;
    }
}

