/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.factory;

import cn.stylefeng.roses.kernel.scanner.api.enums.FieldTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.factory.ClassDetailMetadataFactory;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import cn.stylefeng.roses.kernel.scanner.api.util.ClassDescriptionUtil;
import cn.stylefeng.roses.kernel.scanner.api.util.ClassTypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassMetadataFactory {
    private static final Logger log = LoggerFactory.getLogger(ClassMetadataFactory.class);

    public static FieldMetadata beginCreateFieldMetadata(Type type, String uuid) {
        FieldTypeEnum classFieldType = ClassTypeUtil.getClassFieldType(type);
        FieldMetadata fieldMetadata = null;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            fieldMetadata = ClassDescriptionUtil.createClassMetadata(clazz, classFieldType, uuid);
            Set<FieldMetadata> fieldDetailMetadataSet = ClassDetailMetadataFactory.createFieldDetailMetadataSet(clazz, uuid);
            fieldMetadata.setGenericFieldMetadata(fieldDetailMetadataSet);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            fieldMetadata = ClassDescriptionUtil.createParameterizedMetadata(parameterizedType, classFieldType, uuid);
            Set<FieldMetadata> fieldDetailMetadataSet = ClassDetailMetadataFactory.createFieldDetailMetadataSet(type, uuid);
            fieldMetadata.setGenericFieldMetadata(fieldDetailMetadataSet);
        } else {
            log.debug("\u672a\u77e5\u7c7b\u578b\u7684\u5904\u7406\uff0c\u65e2\u4e0d\u662fclass\u4e5f\u4e0d\u662fParameterizedType\uff0c\u6253\u5370\u51fa\u7c7b\u7684\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)type.getTypeName());
        }
        return fieldMetadata;
    }
}

