/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.TypeUtil;
import cn.stylefeng.roses.kernel.rule.annotation.ChineseDescription;
import cn.stylefeng.roses.kernel.scanner.api.enums.FieldMetadataTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ClassReflectUtil {
    private static final Map<String, String> RUN_MAP = new HashMap<String, String>(2);

    public static Set<FieldMetadata> getClassFieldDescription(Class<?> clazz) {
        LinkedHashSet<FieldMetadata> fieldDescriptions = new LinkedHashSet<FieldMetadata>();
        if (clazz == null) {
            return fieldDescriptions;
        }
        String runClassName = RUN_MAP.get(clazz.getName());
        if (ObjectUtil.isNotEmpty((Object)runClassName)) {
            return null;
        }
        while (clazz != null) {
            Field[] declaredFields;
            RUN_MAP.put(clazz.getName(), clazz.getName());
            for (Field declaredField : declaredFields = ClassUtil.getDeclaredFields(clazz)) {
                FieldMetadata fieldDescription = ClassReflectUtil.getFieldMetadata(declaredField);
                fieldDescriptions.add(fieldDescription);
            }
            RUN_MAP.remove(clazz.getName());
            clazz = clazz.getSuperclass();
        }
        return fieldDescriptions;
    }

    private static FieldMetadata getFieldMetadata(Field declaredField) {
        Class<?> declaredFieldType = declaredField.getType();
        FieldMetadata fieldDescription = ClassReflectUtil.createFieldMetadata(declaredFieldType);
        String name = declaredField.getName();
        fieldDescription.setFieldName(name);
        ClassReflectUtil.fieldClassParsing(declaredField, fieldDescription, declaredFieldType);
        return fieldDescription;
    }

    private static void fieldClassParsing(Field declaredField, FieldMetadata fieldDescription, Class<?> declaredFieldType) {
        ParameterizedType type;
        Type genericType = declaredField.getGenericType();
        if (ClassReflectUtil.isPrimitive(declaredFieldType)) {
            if (genericType instanceof ParameterizedType) {
                type = (ParameterizedType)genericType;
                LinkedHashSet<FieldMetadata> metadataSet = null;
                for (Type actualTypeArgument : type.getActualTypeArguments()) {
                    Class aClass = TypeUtil.getClass((Type)actualTypeArgument);
                    if (!ClassReflectUtil.isPrimitive(aClass)) continue;
                    FieldMetadata fieldMetadata = ClassReflectUtil.baseTypeParsing(declaredField, aClass);
                    if (metadataSet == null) {
                        metadataSet = new LinkedHashSet<FieldMetadata>();
                    }
                    metadataSet.add(fieldMetadata);
                }
                fieldDescription.setGenericFieldMetadataType(FieldMetadataTypeEnum.GENERIC.getCode());
                fieldDescription.setGenericFieldMetadata(metadataSet);
            }
        } else if (declaredFieldType.getComponentType() != null) {
            if (!ClassReflectUtil.isPrimitive(declaredFieldType = declaredFieldType.getComponentType())) {
                fieldDescription.setGenericFieldMetadata(ClassReflectUtil.getClassFieldDescription(declaredFieldType));
            }
        } else {
            fieldDescription.setGenericFieldMetadata(ClassReflectUtil.getClassFieldDescription(declaredFieldType));
        }
        ClassReflectUtil.parsingAnnotation(declaredField, fieldDescription);
        if (genericType instanceof ParameterizedType && ((ParameterizedType)genericType).getActualTypeArguments()[0] instanceof ParameterizedType) {
            type = (ParameterizedType)((ParameterizedType)genericType).getActualTypeArguments()[0];
            Type typeArgument = type.getActualTypeArguments()[0];
            Class clazz = TypeUtil.getClass((Type)typeArgument);
            FieldMetadata fieldMetadataItem = ClassReflectUtil.createFieldMetadata(clazz);
            fieldMetadataItem.setGenericFieldMetadata(ClassReflectUtil.getClassFieldDescription(clazz));
            fieldDescription.setGenericFieldMetadataType(FieldMetadataTypeEnum.GENERIC.getCode());
            fieldDescription.getGenericFieldMetadata().iterator().next().setGenericFieldMetadata(Collections.singleton(fieldMetadataItem));
        } else if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            LinkedHashSet<FieldMetadata> fieldMetadataSet = new LinkedHashSet<FieldMetadata>();
            for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                Class typeClass = TypeUtil.getClass((Type)actualTypeArgument);
                FieldMetadata fieldMetadataItem = ClassReflectUtil.createFieldMetadata(typeClass);
                if (!ClassReflectUtil.isPrimitive(typeClass)) {
                    fieldMetadataItem.setGenericFieldMetadata(ClassReflectUtil.getClassFieldDescription(typeClass));
                } else {
                    FieldMetadata fieldMetadata = ClassReflectUtil.baseTypeParsing(declaredField, typeClass);
                    fieldMetadataItem.setGenericFieldMetadata(Collections.singleton(fieldMetadata));
                }
                fieldMetadataSet.add(fieldMetadataItem);
            }
            Set<FieldMetadata> set = fieldDescription.getGenericFieldMetadata();
            if (ObjectUtil.isNotEmpty(set)) {
                ClassReflectUtil.fieldMetadataGenericFill(set, declaredFieldType, fieldMetadataSet);
            } else {
                fieldDescription.setGenericFieldMetadataType(FieldMetadataTypeEnum.GENERIC.getCode());
                fieldDescription.setGenericFieldMetadata(fieldMetadataSet);
            }
        }
    }

    private static void fieldMetadataGenericFill(Set<FieldMetadata> genericFieldMetadataSet, Class<?> declaredFieldType, Set<FieldMetadata> fieldMetadataSet) {
        Field[] declaredFields;
        HashMap<String, FieldMetadata> genericFieldAndNameMap = new HashMap<String, FieldMetadata>();
        TypeVariable<Class<?>>[] typeParameters = declaredFieldType.getTypeParameters();
        if (ObjectUtil.isNotEmpty(typeParameters)) {
            Iterator<FieldMetadata> iterator = fieldMetadataSet.iterator();
            for (TypeVariable<Class<?>> typeParameter : typeParameters) {
                genericFieldAndNameMap.put(typeParameter.getName(), iterator.next());
            }
        }
        HashMap<String, FieldMetadata> fieldAndNameMap = new HashMap<String, FieldMetadata>(genericFieldMetadataSet.size());
        for (FieldMetadata fieldMetadata : genericFieldMetadataSet) {
            fieldAndNameMap.put(fieldMetadata.getFieldName(), fieldMetadata);
        }
        for (Field field : declaredFields = ClassUtil.getDeclaredFields(declaredFieldType)) {
            FieldMetadata fieldMetadata;
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                Type[] fieldActualTypeArguments;
                ParameterizedType fieldGenericType = (ParameterizedType)type;
                for (Type fieldActualTypeArgument : fieldActualTypeArguments = fieldGenericType.getActualTypeArguments()) {
                    FieldMetadata metadata;
                    FieldMetadata fieldMetadata2 = (FieldMetadata)genericFieldAndNameMap.get(fieldActualTypeArgument.getTypeName());
                    if (!ObjectUtil.isNotEmpty((Object)fieldMetadata2) || !ObjectUtil.isNotEmpty((Object)(metadata = (FieldMetadata)fieldAndNameMap.get(field.getName())))) continue;
                    LinkedHashSet<FieldMetadata> metadataSet = new LinkedHashSet<FieldMetadata>();
                    metadataSet.add(fieldMetadata2);
                    metadata.setGenericFieldMetadata(metadataSet);
                }
                continue;
            }
            if (!(type instanceof TypeVariable) || !ObjectUtil.isNotEmpty((Object)(fieldMetadata = (FieldMetadata)genericFieldAndNameMap.get(type.getTypeName())))) continue;
            FieldMetadata metadata = (FieldMetadata)fieldAndNameMap.get(field.getName());
            BeanUtil.copyProperties((Object)fieldMetadata, (Object)metadata, (String[])new String[0]);
        }
    }

    private static void parsingAnnotation(Field declaredField, FieldMetadata fieldDescription) {
        Annotation[] annotations = declaredField.getAnnotations();
        if (annotations != null && annotations.length > 0) {
            fieldDescription.setAnnotations(ClassReflectUtil.annotationsToStrings(annotations));
            HashMap<String, Set<String>> groupAnnotations = new HashMap<String, Set<String>>();
            for (Annotation annotation : annotations) {
                Class[] validateGroupsClasses = ClassReflectUtil.invokeAnnotationMethodIgnoreError(annotation, "groups", Class[].class);
                if (validateGroupsClasses == null) continue;
                for (Class validateGroupsClass : validateGroupsClasses) {
                    ClassReflectUtil.addGroupValidateAnnotation(annotation, validateGroupsClass, groupAnnotations);
                }
            }
            fieldDescription.setGroupValidationMessage(groupAnnotations);
            ChineseDescription chineseDescription = declaredField.getAnnotation(ChineseDescription.class);
            if (chineseDescription != null) {
                fieldDescription.setChineseName(chineseDescription.value());
            }
        }
    }

    private static FieldMetadata baseTypeParsing(Field declaredField, Class<?> actualTypeArgument) {
        FieldMetadata item = ClassReflectUtil.createFieldMetadata(actualTypeArgument);
        item.setFieldName(actualTypeArgument.getName());
        ChineseDescription chineseDescription = declaredField.getAnnotation(ChineseDescription.class);
        if (null != chineseDescription) {
            item.setChineseName(chineseDescription.value());
        }
        return item;
    }

    public static <T> T invokeAnnotationMethodIgnoreError(Annotation apiResource, String methodName, Class<T> resultType) {
        try {
            Class<? extends Annotation> annotationType = apiResource.annotationType();
            Method method = annotationType.getMethod(methodName, new Class[0]);
            return (T)method.invoke((Object)apiResource, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public static void addGroupValidateAnnotation(Annotation fieldAnnotation, Class<?> validateGroupsClass, Map<String, Set<String>> groupAnnotations) {
        Set<String> annotations = groupAnnotations.get(validateGroupsClass.getSimpleName());
        if (annotations == null) {
            annotations = new HashSet<String>();
        }
        String messageTip = ClassReflectUtil.invokeAnnotationMethodIgnoreError(fieldAnnotation, "message", String.class);
        annotations.add(messageTip);
        groupAnnotations.put(validateGroupsClass.getSimpleName(), annotations);
    }

    public static Set<String> annotationsToStrings(Annotation[] annotations) {
        HashSet<String> strings = new HashSet<String>();
        if (annotations == null || annotations.length == 0) {
            return strings;
        }
        for (Annotation annotation : annotations) {
            strings.add(annotation.annotationType().getSimpleName());
        }
        return strings;
    }

    private static boolean isPrimitive(Class<?> clazz) {
        boolean isPrimitive;
        try {
            isPrimitive = clazz.isPrimitive() ? true : ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            isPrimitive = false;
        }
        Package packageObj = clazz.getPackage();
        if (!isPrimitive && ObjectUtil.isNotEmpty((Object)packageObj)) {
            isPrimitive = "java.lang".equals(packageObj.getName()) || "java.util".equals(packageObj.getName()) || "java.math".equals(packageObj.getName());
        }
        return isPrimitive;
    }

    private static FieldMetadata createFieldMetadata(Class<?> typeArgumentItem) {
        FieldMetadata fieldMetadataItem = new FieldMetadata();
        fieldMetadataItem.setMetadataId(IdUtil.fastSimpleUUID());
        fieldMetadataItem.setFieldName(typeArgumentItem.getSimpleName());
        fieldMetadataItem.setFieldClassType(typeArgumentItem.getSimpleName());
        fieldMetadataItem.setFieldClassPath(typeArgumentItem.getName());
        fieldMetadataItem.setGenericFieldMetadataType(FieldMetadataTypeEnum.FIELD.getCode());
        return fieldMetadataItem;
    }
}

