/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner;

import cn.stylefeng.roses.kernel.scanner.api.ResourceCollectorApi;
import cn.stylefeng.roses.kernel.scanner.api.ResourceReportApi;
import cn.stylefeng.roses.kernel.scanner.api.constants.ScannerConstants;
import cn.stylefeng.roses.kernel.scanner.api.holder.InitScanFlagHolder;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ReportResourceParam;
import cn.stylefeng.roses.kernel.scanner.api.pojo.scanner.ScannerProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.Ordered;

public class ResourceReportListener
implements ApplicationListener<ApplicationReadyEvent>,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ResourceReportListener.class);

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        if (applicationContext instanceof AnnotationConfigApplicationContext) {
            return;
        }
        ScannerProperties scannerProperties = (ScannerProperties)applicationContext.getBean(ScannerProperties.class);
        if (!scannerProperties.getOpen().booleanValue()) {
            return;
        }
        if (!InitScanFlagHolder.getFlag().booleanValue()) {
            ResourceCollectorApi resourceCollectorApi = (ResourceCollectorApi)applicationContext.getBean(ResourceCollectorApi.class);
            Map modularResources = resourceCollectorApi.getModularResources();
            ResourceReportApi resourceService = (ResourceReportApi)applicationContext.getBean(ResourceReportApi.class);
            resourceService.reportResources(new ReportResourceParam(scannerProperties.getAppCode(), modularResources));
            InitScanFlagHolder.setFlag();
        }
    }

    public int getOrder() {
        return ScannerConstants.REPORT_RESOURCE_LISTENER_SORT;
    }
}

