/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.rule.enums.ResBizTypeEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.AopTargetUtils;
import cn.stylefeng.roses.kernel.scanner.api.ResourceCollectorApi;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.scanner.api.context.MetadataContext;
import cn.stylefeng.roses.kernel.scanner.api.enums.ParamTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.exception.ScannerException;
import cn.stylefeng.roses.kernel.scanner.api.exception.enums.ScannerExceptionEnum;
import cn.stylefeng.roses.kernel.scanner.api.factory.ClassMetadataFactory;
import cn.stylefeng.roses.kernel.scanner.api.holder.IpAddrHolder;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ParameterMetadata;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.scanner.api.pojo.scanner.ScannerProperties;
import cn.stylefeng.roses.kernel.scanner.api.util.MethodReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

public class ApiResourceScanner
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ApiResourceScanner.class);
    private final ResourceCollectorApi resourceCollectorApi;
    private final ScannerProperties scannerProperties;

    public ApiResourceScanner(ResourceCollectorApi resourceCollectorApi, ScannerProperties scannerProperties) {
        this.resourceCollectorApi = resourceCollectorApi;
        this.scannerProperties = scannerProperties;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz;
        boolean controllerFlag;
        Object aopTarget = AopTargetUtils.getTarget((Object)bean);
        if (aopTarget == null) {
            aopTarget = bean;
        }
        if (!(controllerFlag = this.getControllerFlag(clazz = aopTarget.getClass()))) {
            return bean;
        }
        List<ResourceDefinition> apiResources = this.doScan(clazz);
        this.persistApiResources(apiResources);
        return bean;
    }

    private boolean getControllerFlag(Class<?> clazz) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = clazz.getAnnotations()) {
            if (!RestController.class.equals(annotation.annotationType()) && !Controller.class.equals(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private List<ResourceDefinition> doScan(Class<?> clazz) {
        ApiResource classApiAnnotation = clazz.getAnnotation(ApiResource.class);
        if (classApiAnnotation != null) {
            if (StrUtil.isEmpty((CharSequence)classApiAnnotation.code())) {
                String className = clazz.getSimpleName();
                int controllerIndex = className.indexOf("Controller");
                if (controllerIndex == -1) {
                    throw new IllegalArgumentException("controller class name is not illegal, it should end with Controller!");
                }
                String code = className.substring(0, controllerIndex);
                this.resourceCollectorApi.bindResourceName(StrUtil.toUnderlineCase((CharSequence)code), classApiAnnotation.name());
            } else {
                this.resourceCollectorApi.bindResourceName(StrUtil.toUnderlineCase((CharSequence)classApiAnnotation.code()), classApiAnnotation.name());
            }
        }
        ArrayList<ResourceDefinition> apiResources = new ArrayList<ResourceDefinition>();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        if (declaredMethods.length > 0) {
            for (Method declaredMethod : declaredMethods) {
                ApiResource apiResource = declaredMethod.getAnnotation(ApiResource.class);
                GetResource getResource = declaredMethod.getAnnotation(GetResource.class);
                PostResource postResource = declaredMethod.getAnnotation(PostResource.class);
                ApiResource annotation = null;
                if (apiResource != null) {
                    annotation = apiResource;
                }
                if (getResource != null) {
                    annotation = getResource;
                }
                if (postResource != null) {
                    annotation = postResource;
                }
                if (annotation == null) continue;
                ResourceDefinition definition = this.createDefinition(clazz, declaredMethod, (Annotation)annotation);
                apiResources.add(definition);
                log.debug("\u626b\u63cf\u5230\u8d44\u6e90: " + definition);
            }
        }
        return apiResources;
    }

    private void persistApiResources(List<ResourceDefinition> apiResources) {
        this.resourceCollectorApi.collectResources(apiResources);
    }

    private ResourceDefinition createDefinition(Class<?> controllerClass, Method method, Annotation apiResource) {
        ResourceDefinition resourceDefinition = new ResourceDefinition();
        resourceDefinition.setClassName(controllerClass.getSimpleName());
        resourceDefinition.setMethodName(method.getName());
        String className = resourceDefinition.getClassName();
        int controllerIndex = className.indexOf("Controller");
        if (controllerIndex == -1) {
            throw new ScannerException((AbstractExceptionEnum)ScannerExceptionEnum.ERROR_CONTROLLER_NAME, new Object[]{controllerClass.getName()});
        }
        String modular = className.substring(0, controllerIndex);
        resourceDefinition.setModularCode(modular);
        ApiResource classApiAnnotation = controllerClass.getAnnotation(ApiResource.class);
        resourceDefinition.setModularName(classApiAnnotation.name());
        if (StrUtil.isNotBlank((CharSequence)classApiAnnotation.appCode())) {
            resourceDefinition.setAppCode(classApiAnnotation.appCode());
        } else {
            resourceDefinition.setAppCode(this.scannerProperties.getAppCode());
        }
        String code = this.invokeAnnotationMethod(apiResource, "code", String.class);
        if (StrUtil.isEmpty((CharSequence)code)) {
            resourceDefinition.setResourceCode(resourceDefinition.getAppCode() + this.scannerProperties.getLinkSymbol() + StrUtil.toUnderlineCase((CharSequence)modular) + this.scannerProperties.getLinkSymbol() + StrUtil.toUnderlineCase((CharSequence)method.getName()));
        } else {
            resourceDefinition.setResourceCode(resourceDefinition.getAppCode() + this.scannerProperties.getLinkSymbol() + StrUtil.toUnderlineCase((CharSequence)modular) + this.scannerProperties.getLinkSymbol() + StrUtil.toUnderlineCase((CharSequence)code));
        }
        String name = this.invokeAnnotationMethod(apiResource, "name", String.class);
        String[] methodPath = this.invokeAnnotationMethod(apiResource, "path", String[].class);
        RequestMethod[] requestMethods = this.invokeAnnotationMethod(apiResource, "method", RequestMethod[].class);
        Boolean viewFlag = this.invokeAnnotationMethod(apiResource, "viewFlag", Boolean.class);
        ResBizTypeEnum methodResBizType = this.invokeAnnotationMethod(apiResource, "resBizType", ResBizTypeEnum.class);
        resourceDefinition.setResourceName(name);
        this.processPermissionWithParentCondition(classApiAnnotation, apiResource, resourceDefinition);
        if (!methodResBizType.equals((Object)ResBizTypeEnum.DEFAULT)) {
            resourceDefinition.setResourceBizType(methodResBizType.getCode());
        } else {
            resourceDefinition.setResourceBizType(classApiAnnotation.resBizType().getCode());
        }
        String controllerMethodPath = this.createControllerPath(controllerClass, methodPath[0]);
        resourceDefinition.setUrl(this.createFinalUrl(controllerMethodPath));
        if (viewFlag.booleanValue()) {
            resourceDefinition.setViewFlag(Boolean.valueOf(true));
        } else if (StrUtil.isNotBlank((CharSequence)controllerMethodPath)) {
            resourceDefinition.setViewFlag(Boolean.valueOf(controllerMethodPath.toLowerCase().startsWith("/view")));
        } else {
            resourceDefinition.setViewFlag(Boolean.valueOf(false));
        }
        StringBuilder methodNames = new StringBuilder();
        for (RequestMethod requestMethod : requestMethods) {
            methodNames.append(requestMethod.name()).append(",");
        }
        resourceDefinition.setHttpMethod(StrUtil.removeSuffix((CharSequence)methodNames.toString(), (CharSequence)","));
        String localMacAddress = IpAddrHolder.get();
        if (localMacAddress == null) {
            try {
                localMacAddress = NetUtil.getLocalhostStr();
                IpAddrHolder.set((String)localMacAddress);
            }
            catch (UtilException e) {
                log.error("\u83b7\u53d6\u5f53\u524d\u673a\u5668ip\u5730\u5740\u9519\u8bef\uff01");
            }
        }
        resourceDefinition.setIpAddress(localMacAddress == null ? "" : localMacAddress);
        resourceDefinition.setCreateTime(new Date());
        resourceDefinition.setProjectCode(this.scannerProperties.getAppCode());
        Set methodValidateGroup = MethodReflectUtil.getMethodValidateGroup((Method)method);
        if (methodValidateGroup != null) {
            resourceDefinition.setValidateGroups(methodValidateGroup);
        }
        Type returnType = MethodReflectUtil.getMethodReturnType((Method)method);
        String processReturnTypeUuid = RandomUtil.randomString((int)32);
        resourceDefinition.setResponseFieldDescriptions(ClassMetadataFactory.beginCreateFieldMetadata((Type)returnType, (String)processReturnTypeUuid));
        MetadataContext.cleanContext((String)processReturnTypeUuid);
        List methodParameterInfos = MethodReflectUtil.getMethodParameterInfos((Method)method);
        if (methodParameterInfos.size() > 0) {
            LinkedHashSet<FieldMetadata> fieldMetadataLinkedHashSet = new LinkedHashSet<FieldMetadata>();
            for (ParameterMetadata parameterMetadata : methodParameterInfos) {
                String parameterContextUuid = RandomUtil.randomString((int)32);
                MetadataContext.addParamTypeMetadata((String)parameterContextUuid, (ParamTypeEnum)parameterMetadata.getParamTypeEnum());
                MetadataContext.addParameterName((String)parameterContextUuid, (String)parameterMetadata.getParameterName());
                fieldMetadataLinkedHashSet.add(ClassMetadataFactory.beginCreateFieldMetadata((Type)parameterMetadata.getParameterizedType(), (String)parameterContextUuid));
                MetadataContext.cleanContext((String)parameterContextUuid);
            }
            resourceDefinition.setParamFieldDescriptions(fieldMetadataLinkedHashSet);
        }
        return resourceDefinition;
    }

    private String createControllerPath(Class<?> clazz, String path) {
        String[] paths;
        ApiResource controllerRequestMapping = clazz.getDeclaredAnnotation(ApiResource.class);
        String controllerPath = controllerRequestMapping == null ? "" : ((paths = controllerRequestMapping.path()).length > 0 ? paths[0] : "");
        if (!controllerPath.startsWith("/")) {
            controllerPath = "/" + controllerPath;
        }
        return (controllerPath + path).replaceAll("/+", "/");
    }

    private String createFinalUrl(String controllerMethodPath) {
        String appCode = "";
        if (this.scannerProperties.getUrlWithAppCode().booleanValue()) {
            appCode = "/" + StrUtil.removePrefix((CharSequence)this.scannerProperties.getAppCode(), (CharSequence)"/");
        }
        String contextPath = "";
        if (this.scannerProperties.getUrlWithContextPath().booleanValue()) {
            contextPath = "/" + StrUtil.removePrefix((CharSequence)this.scannerProperties.getContextPath(), (CharSequence)"/");
        }
        String resultPath = appCode + contextPath + controllerMethodPath;
        resultPath = resultPath.replaceAll("/+", "/");
        return resultPath;
    }

    private <T> T invokeAnnotationMethod(Annotation apiResource, String methodName, Class<T> resultType) {
        try {
            Class<? extends Annotation> annotationType = apiResource.annotationType();
            Method method = annotationType.getMethod(methodName, new Class[0]);
            return (T)method.invoke((Object)apiResource, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("\u626b\u63cfapi\u8d44\u6e90\u65f6\u51fa\u9519!", (Throwable)e);
            throw new RuntimeException("\u626b\u63cfapi\u8d44\u6e90\u65f6\u51fa\u9519!");
        }
    }

    private void processPermissionWithParentCondition(ApiResource classApiAnnotation, Annotation methodApiResource, ResourceDefinition resourceDefinition) {
        Boolean requiredLogin = this.invokeAnnotationMethod(methodApiResource, "requiredLogin", Boolean.class);
        resourceDefinition.setRequiredLoginFlag(requiredLogin);
        Boolean requiredPermission = this.invokeAnnotationMethod(methodApiResource, "requiredPermission", Boolean.class);
        String requirePermissionCode = this.invokeAnnotationMethod(methodApiResource, "requirePermissionCode", String.class);
        if (requiredPermission == null || !requiredPermission.booleanValue()) {
            if (ObjectUtil.isNotEmpty((Object)requirePermissionCode)) {
                requiredPermission = true;
            } else if (ObjectUtil.isNotEmpty((Object)classApiAnnotation.requirePermissionCode())) {
                requiredPermission = true;
                requirePermissionCode = classApiAnnotation.requirePermissionCode();
            }
        }
        resourceDefinition.setRequiredPermissionFlag(requiredPermission);
        resourceDefinition.setPermissionCode(requirePermissionCode);
    }
}

