/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.database.interceptor;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.security.database.algorithm.EncryptAlgorithmApi;
import cn.stylefeng.roses.kernel.security.database.annotation.ProtectedData;
import cn.stylefeng.roses.kernel.security.database.annotation.ProtectedField;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class ResultInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ResultInterceptor.class);
    @Autowired
    private EncryptAlgorithmApi encryptAlgorithmApi;

    public Object intercept(Invocation invocation) throws Throwable {
        Object resultObject = invocation.proceed();
        if (Objects.isNull(resultObject)) {
            return null;
        }
        if (resultObject instanceof List) {
            List resultList = (List)resultObject;
            if (ObjectUtil.isNotNull((Object)resultList)) {
                for (Object result : resultList) {
                    this.objectProcessing(result);
                }
            }
        } else {
            this.objectProcessing(resultObject);
        }
        return resultObject;
    }

    private void objectProcessing(Object result) throws IllegalAccessException {
        Class<?> resultClass = result.getClass();
        ProtectedData annotation = (ProtectedData)AnnotationUtils.findAnnotation(resultClass, ProtectedData.class);
        if (ObjectUtil.isNotNull((Object)annotation)) {
            Field[] declaredFields;
            for (Field field : declaredFields = resultClass.getDeclaredFields()) {
                this.fieldProcessing(result, field);
            }
        }
    }

    private void fieldProcessing(Object result, Field field) throws IllegalAccessException {
        if (this.isTag(field)) {
            field.setAccessible(true);
            Object object = field.get(result);
            if (object instanceof String) {
                String value = (String)object;
                try {
                    String decrypt = this.encryptAlgorithmApi.decrypt(value);
                    field.set(result, decrypt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isTag(Field field) {
        ProtectedField protectedField = field.getAnnotation(ProtectedField.class);
        return ObjectUtil.isNotNull((Object)protectedField);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

