/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.xss;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HtmlUtil;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import cn.stylefeng.roses.kernel.security.xss.prop.XssProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.springframework.util.AntPathMatcher;

public class XssJacksonDeserializer
extends JsonDeserializer<String> {
    private final XssProperties xssProperties;

    public XssJacksonDeserializer(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }

    public String deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        String servletPath = HttpServletUtil.getRequest().getServletPath();
        String contextPath = HttpServletUtil.getRequest().getContextPath();
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        if (this.xssProperties != null && ObjectUtil.isNotEmpty(this.xssProperties.getUrlExclusion())) {
            for (String exclusion : this.xssProperties.getUrlExclusion()) {
                if (!antPathMatcher.match(contextPath + exclusion, servletPath)) continue;
                return jsonParser.getText();
            }
        }
        return HtmlUtil.filter((String)jsonParser.getText());
    }
}

