/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.xss;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.security.xss.XssHttpServletRequestWrapper;
import cn.stylefeng.roses.kernel.security.xss.prop.XssProperties;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.AntPathMatcher;

public class XssFilter
implements Filter {
    public static final String FILTER_NAME = "GUNS_XSS_FILTER";
    private final XssProperties xssProperties;

    public XssFilter(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String servletPath = httpServletRequest.getServletPath();
        String contextPath = httpServletRequest.getContextPath();
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        if (this.xssProperties != null && ObjectUtil.isNotEmpty(this.xssProperties.getUrlExclusion())) {
            for (String exclusion : this.xssProperties.getUrlExclusion()) {
                if (!antPathMatcher.match(contextPath + exclusion, contextPath + servletPath)) continue;
                chain.doFilter(request, response);
                return;
            }
        }
        chain.doFilter((ServletRequest)new XssHttpServletRequestWrapper((HttpServletRequest)request), response);
    }
}

