/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.starter;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.cache.api.constants.CacheConstants;
import cn.stylefeng.roses.kernel.security.api.BlackListApi;
import cn.stylefeng.roses.kernel.security.api.CountValidatorApi;
import cn.stylefeng.roses.kernel.security.api.WhiteListApi;
import cn.stylefeng.roses.kernel.security.blackwhite.BlackListService;
import cn.stylefeng.roses.kernel.security.blackwhite.WhiteListService;
import cn.stylefeng.roses.kernel.security.blackwhite.cache.BlackListMemoryCache;
import cn.stylefeng.roses.kernel.security.blackwhite.cache.WhiteListMemoryCache;
import cn.stylefeng.roses.kernel.security.count.DefaultCountValidator;
import cn.stylefeng.roses.kernel.security.count.cache.DefaultCountValidateCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CounterAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BlackListApi.class})
    public BlackListApi blackListApi() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        BlackListMemoryCache blackListMemoryCache = new BlackListMemoryCache(timedCache);
        return new BlackListService((CacheOperatorApi)blackListMemoryCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={CountValidatorApi.class})
    public CountValidatorApi countValidatorApi() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        DefaultCountValidateCache defaultCountValidateCache = new DefaultCountValidateCache(timedCache);
        return new DefaultCountValidator((CacheOperatorApi)defaultCountValidateCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={WhiteListApi.class})
    public WhiteListApi whiteListApi() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        WhiteListMemoryCache whiteListMemoryCache = new WhiteListMemoryCache(timedCache);
        return new WhiteListService((CacheOperatorApi)whiteListMemoryCache);
    }
}

