/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.starter;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.security.api.DragCaptchaApi;
import cn.stylefeng.roses.kernel.security.api.ImageCaptchaApi;
import cn.stylefeng.roses.kernel.security.captcha.DragCaptchaService;
import cn.stylefeng.roses.kernel.security.captcha.ImageCaptchaService;
import cn.stylefeng.roses.kernel.security.captcha.cache.CaptchaMemoryCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CaptchaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ImageCaptchaApi.class})
    public ImageCaptchaApi captchaApi() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)120000L);
        CaptchaMemoryCache captchaMemoryCache = new CaptchaMemoryCache(timedCache);
        return new ImageCaptchaService((CacheOperatorApi)captchaMemoryCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={DragCaptchaApi.class})
    public DragCaptchaApi dragCaptchaService() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)120000L);
        CaptchaMemoryCache captchaMemoryCache = new CaptchaMemoryCache(timedCache);
        return new DragCaptchaService((CacheOperatorApi)captchaMemoryCache);
    }
}

