/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.starter.cache;

import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.cache.redis.util.CreateRedisTemplateUtil;
import cn.stylefeng.roses.kernel.security.blackwhite.cache.BlackListRedisCache;
import cn.stylefeng.roses.kernel.security.blackwhite.cache.WhiteListRedisCache;
import cn.stylefeng.roses.kernel.security.captcha.cache.CaptchaRedisCache;
import cn.stylefeng.roses.kernel.security.count.cache.CountValidateRedisCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@ConditionalOnClass(name={"org.springframework.data.redis.connection.RedisConnectionFactory"})
public class SecurityRedisCacheAutoConfiguration {
    @Bean(value={"captchaCache"})
    public CacheOperatorApi<String> captchaRedisCache(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createString((RedisConnectionFactory)redisConnectionFactory);
        return new CaptchaRedisCache(redisTemplate);
    }

    @Bean(value={"blackListCache"})
    public CacheOperatorApi<String> blackListRedisCache(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createString((RedisConnectionFactory)redisConnectionFactory);
        return new BlackListRedisCache(redisTemplate);
    }

    @Bean(value={"whiteListCache"})
    public CacheOperatorApi<String> whiteListRedisCache(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createString((RedisConnectionFactory)redisConnectionFactory);
        return new WhiteListRedisCache(redisTemplate);
    }

    @Bean(value={"countValidateCache"})
    public CacheOperatorApi<Long> countValidateRedisCache(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new CountValidateRedisCache(redisTemplate);
    }
}

