/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.starter;

import cn.stylefeng.roses.kernel.security.api.expander.SecurityConfigExpander;
import cn.stylefeng.roses.kernel.security.xss.XssFilter;
import cn.stylefeng.roses.kernel.security.xss.XssJacksonDeserializer;
import cn.stylefeng.roses.kernel.security.xss.prop.XssProperties;
import com.fasterxml.jackson.databind.JsonDeserializer;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

public class ProjectXssAutoConfiguration {
    @Bean
    public FilterRegistrationBean<XssFilter> xssFilterFilterRegistrationBean() {
        XssProperties properties = this.createProperties();
        FilterRegistrationBean xssFilterFilterRegistrationBean = new FilterRegistrationBean();
        xssFilterFilterRegistrationBean.setFilter((Filter)new XssFilter(properties));
        xssFilterFilterRegistrationBean.addUrlPatterns(properties.getUrlPatterns());
        xssFilterFilterRegistrationBean.setName("GUNS_XSS_FILTER");
        xssFilterFilterRegistrationBean.setOrder(Integer.MIN_VALUE);
        return xssFilterFilterRegistrationBean;
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer xssJackson2ObjectMapperBuilderCustomizer() {
        return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.deserializerByType(String.class, (JsonDeserializer)new XssJacksonDeserializer(this.createProperties()));
    }

    private XssProperties createProperties() {
        XssProperties xssProperties = new XssProperties();
        xssProperties.setUrlPatterns(SecurityConfigExpander.getUrlPatterns());
        xssProperties.setUrlExclusion(SecurityConfigExpander.getUrlExclusion());
        return xssProperties;
    }
}

