/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sms.tencent;

import cn.hutool.core.util.ArrayUtil;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.sms.api.SmsSenderApi;
import cn.stylefeng.roses.kernel.sms.api.exception.SmsException;
import cn.stylefeng.roses.kernel.sms.api.exception.enums.SmsExceptionEnum;
import cn.stylefeng.roses.kernel.sms.api.pojo.TencentSmsProperties;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.sms.v20190711.SmsClient;
import com.tencentcloudapi.sms.v20190711.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20190711.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20190711.models.SendStatus;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

public class TencentSmsSender
implements SmsSenderApi {
    private TencentSmsProperties tencentSmsProperties;

    public TencentSmsSender(TencentSmsProperties tencentSmsProperties) {
        this.tencentSmsProperties = tencentSmsProperties;
    }

    public void sendSms(String phone, String templateCode, Map<String, Object> params) {
        try {
            SendSmsResponse res;
            SendStatus[] sendStatusSet;
            Credential cred = new Credential(this.tencentSmsProperties.getSecretId(), this.tencentSmsProperties.getSecretKey());
            HttpProfile httpProfile = new HttpProfile();
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setSignMethod("HmacSHA256");
            clientProfile.setHttpProfile(httpProfile);
            SmsClient client = new SmsClient(cred, "ap-guangzhou", clientProfile);
            SendSmsRequest req = new SendSmsRequest();
            req.setSmsSdkAppid(this.tencentSmsProperties.getSdkAppId());
            req.setSign(this.tencentSmsProperties.getSign());
            req.setTemplateID(templateCode);
            String[] phoneNumbers = new String[]{"+86" + phone};
            req.setPhoneNumberSet(phoneNumbers);
            if (params != null && params.size() > 0) {
                LinkedList<String> strings = new LinkedList<String>();
                Collection<Object> values = params.values();
                for (Object value : values) {
                    strings.add(value.toString());
                }
                req.setTemplateParamSet((String[])ArrayUtil.toArray(strings, String.class));
            }
            if ((sendStatusSet = (res = client.SendSms(req)).getSendStatusSet()) != null && sendStatusSet.length > 0 && !sendStatusSet[0].getCode().equals("Ok")) {
                throw new SmsException((AbstractExceptionEnum)SmsExceptionEnum.TENCENT_SMS_PARAM_NULL, new Object[]{sendStatusSet[0].getCode(), sendStatusSet[0].getMessage()});
            }
        }
        catch (TencentCloudSDKException e) {
            throw new SmsException((AbstractExceptionEnum)SmsExceptionEnum.TENCENT_SMS_PARAM_NULL, new Object[]{SmsExceptionEnum.TENCENT_SMS_PARAM_NULL.getErrorCode(), e.getMessage()});
        }
    }
}

