/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.socket.business.websocket.operator;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.socket.api.SocketOperatorApi;
import cn.stylefeng.roses.kernel.socket.api.exception.SocketException;
import cn.stylefeng.roses.kernel.socket.api.exception.enums.SocketExceptionEnum;
import cn.stylefeng.roses.kernel.socket.api.message.SocketMsgCallbackInterface;
import cn.stylefeng.roses.kernel.socket.api.session.pojo.SocketSession;
import cn.stylefeng.roses.kernel.socket.business.websocket.message.SocketMessageCenter;
import cn.stylefeng.roses.kernel.socket.business.websocket.operator.channel.GunsSocketOperator;
import cn.stylefeng.roses.kernel.socket.business.websocket.pojo.WebSocketMessageDTO;
import cn.stylefeng.roses.kernel.socket.business.websocket.session.SessionCenter;
import java.util.Collection;
import java.util.List;

public class WebSocketOperator
implements SocketOperatorApi {
    public void sendMsgOfUserSessionBySessionId(String msgType, String sessionId, Object msg) throws SocketException {
        SocketSession<GunsSocketOperator> session = SessionCenter.getSessionBySessionId(sessionId);
        if (ObjectUtil.isEmpty(session)) {
            throw new SocketException((AbstractExceptionEnum)SocketExceptionEnum.SESSION_NOT_EXIST);
        }
        WebSocketMessageDTO webSocketMessageDTO = new WebSocketMessageDTO();
        webSocketMessageDTO.setData(msg);
        webSocketMessageDTO.setServerMsgType(msgType);
        ((GunsSocketOperator)session.getSocketOperatorApi()).writeAndFlush(webSocketMessageDTO);
    }

    public void sendMsgOfUserSession(String msgType, String userId, Object msg) throws SocketException {
        List<SocketSession<GunsSocketOperator>> socketSessionList = SessionCenter.getSessionByUserIdAndMsgType(userId);
        if (ObjectUtil.isEmpty(socketSessionList)) {
            throw new SocketException((AbstractExceptionEnum)SocketExceptionEnum.SESSION_NOT_EXIST);
        }
        WebSocketMessageDTO webSocketMessageDTO = new WebSocketMessageDTO();
        webSocketMessageDTO.setData(msg);
        webSocketMessageDTO.setServerMsgType(msgType);
        for (SocketSession<GunsSocketOperator> session : socketSessionList) {
            ((GunsSocketOperator)session.getSocketOperatorApi()).writeAndFlush(webSocketMessageDTO);
        }
    }

    public void sendMsgOfAllUserSession(String msgType, Object msg) {
        Collection values = SessionCenter.getSocketSessionMap().values();
        WebSocketMessageDTO webSocketMessageDTO = new WebSocketMessageDTO();
        webSocketMessageDTO.setData(msg);
        webSocketMessageDTO.setServerMsgType(msgType);
        for (List sessions : values) {
            for (SocketSession session : sessions) {
                if (!session.getMessageType().equals(msgType)) continue;
                ((GunsSocketOperator)session.getSocketOperatorApi()).writeAndFlush(webSocketMessageDTO);
            }
        }
    }

    public void closeSocketBySocketId(String socketId) {
        SessionCenter.closed(socketId);
    }

    public void msgTypeCallback(String msgType, SocketMsgCallbackInterface callbackInterface) {
        SocketMessageCenter.setMessageListener(msgType, callbackInterface);
    }
}

