/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.socket.business.websocket.session;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.socket.api.session.pojo.SocketSession;
import cn.stylefeng.roses.kernel.socket.business.websocket.operator.channel.GunsSocketOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SessionCenter {
    private static ConcurrentMap<String, List<SocketSession<GunsSocketOperator>>> socketSessionMap = new ConcurrentHashMap<String, List<SocketSession<GunsSocketOperator>>>();

    public static ConcurrentMap<String, List<SocketSession<GunsSocketOperator>>> getSocketSessionMap() {
        return socketSessionMap;
    }

    public static List<SocketSession<GunsSocketOperator>> getSessionByUserId(String userId) {
        return (List)socketSessionMap.get(userId);
    }

    public static List<SocketSession<GunsSocketOperator>> getSessionByUserIdAndMsgType(String userId) {
        return (List)socketSessionMap.get(userId);
    }

    public static SocketSession<GunsSocketOperator> getSessionBySessionId(String sessionId) {
        Set entrySet = socketSessionMap.entrySet();
        for (Map.Entry stringListEntry : entrySet) {
            List stringListEntryValue = (List)stringListEntry.getValue();
            for (SocketSession socketSession : stringListEntryValue) {
                if (!sessionId.equals(socketSession.getSessionId())) continue;
                return socketSession;
            }
        }
        return null;
    }

    public static void addSocketSession(SocketSession<GunsSocketOperator> socketSession) {
        List<SocketSession<GunsSocketOperator>> socketSessions = (List<SocketSession<GunsSocketOperator>>)socketSessionMap.get(socketSession.getUserId());
        if (ObjectUtil.isEmpty((Object)socketSessions)) {
            socketSessions = Collections.synchronizedList(new ArrayList());
            socketSessionMap.put(socketSession.getUserId(), socketSessions);
        }
        socketSessions.add(socketSession);
    }

    public static void closed(String sessionId) {
        SocketSession<GunsSocketOperator> operatorSocketSession = SessionCenter.getSessionBySessionId(sessionId);
        if (ObjectUtil.isNotEmpty(operatorSocketSession)) {
            ((GunsSocketOperator)operatorSocketSession.getSocketOperatorApi()).close();
        }
    }

    public static SocketSession<GunsSocketOperator> deleteById(String sessionId) {
        Set entrySet = socketSessionMap.entrySet();
        for (Map.Entry next : entrySet) {
            List value = (List)next.getValue();
            if (!ObjectUtil.isNotEmpty((Object)value)) continue;
            Iterator socketSessionIterator = value.iterator();
            while (socketSessionIterator.hasNext()) {
                SocketSession operatorSocketSession = (SocketSession)socketSessionIterator.next();
                if (!operatorSocketSession.getSessionId().equals(sessionId)) continue;
                socketSessionIterator.remove();
                return operatorSocketSession;
            }
        }
        return null;
    }
}

