/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.socket.business.websocket.server;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.AuthJwtContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.payload.DefaultJwtPayload;
import cn.stylefeng.roses.kernel.socket.api.enums.ClientMessageTypeEnum;
import cn.stylefeng.roses.kernel.socket.api.enums.ServerMessageTypeEnum;
import cn.stylefeng.roses.kernel.socket.api.enums.SystemMessageTypeEnum;
import cn.stylefeng.roses.kernel.socket.api.message.SocketMsgCallbackInterface;
import cn.stylefeng.roses.kernel.socket.api.session.SocketSessionOperatorApi;
import cn.stylefeng.roses.kernel.socket.api.session.pojo.SocketSession;
import cn.stylefeng.roses.kernel.socket.business.websocket.message.SocketMessageCenter;
import cn.stylefeng.roses.kernel.socket.business.websocket.operator.channel.GunsSocketOperator;
import cn.stylefeng.roses.kernel.socket.business.websocket.pojo.WebSocketMessageDTO;
import cn.stylefeng.roses.kernel.socket.business.websocket.session.SessionCenter;
import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.JwtException;
import java.io.IOException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/webSocket/{token}")
@Component
public class WebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnOpen
    public void onOpen(Session session, @PathParam(value="token") String token) {
        String userId = null;
        try {
            DefaultJwtPayload defaultPayload = AuthJwtContext.me().getDefaultPayload(token);
            userId = defaultPayload.getUserId().toString();
        }
        catch (JwtException e) {
            try {
                session.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        GunsSocketOperator gunsSocketOperator = new GunsSocketOperator(session);
        WebSocketMessageDTO replyMsg = new WebSocketMessageDTO();
        replyMsg.setServerMsgType(ServerMessageTypeEnum.SYS_REPLY_MSG_TYPE.getCode());
        replyMsg.setToUserId(userId);
        SocketSession socketSession = new SocketSession();
        try {
            replyMsg.setData(session.getId());
            socketSession.setSessionId(session.getId());
            socketSession.setUserId(userId);
            socketSession.setSocketOperatorApi((SocketSessionOperatorApi)gunsSocketOperator);
            socketSession.setToken(token);
            socketSession.setConnectionTime(Long.valueOf(System.currentTimeMillis()));
            SessionCenter.addSocketSession((SocketSession<GunsSocketOperator>)socketSession);
        }
        finally {
            gunsSocketOperator.writeAndFlush(replyMsg);
            SocketMsgCallbackInterface socketMsgCallbackInterface = SocketMessageCenter.getSocketMsgCallbackInterface(SystemMessageTypeEnum.SYS_LISTENER_ONOPEN.getCode());
            if (ObjectUtil.isNotEmpty((Object)socketMsgCallbackInterface)) {
                socketMsgCallbackInterface.callback(SystemMessageTypeEnum.SYS_LISTENER_ONOPEN.getCode(), null, socketSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClose
    public void onClose(Session session) {
        try {
            SocketSession<GunsSocketOperator> socketSession = SessionCenter.getSessionBySessionId(session.getId());
            SocketMsgCallbackInterface socketMsgCallbackInterface = SocketMessageCenter.getSocketMsgCallbackInterface(SystemMessageTypeEnum.SYS_LISTENER_ONCLOSE.getCode());
            if (ObjectUtil.isNotEmpty(socketSession) && ObjectUtil.isNotEmpty((Object)socketMsgCallbackInterface)) {
                socketMsgCallbackInterface.callback(SystemMessageTypeEnum.SYS_LISTENER_ONCLOSE.getCode(), null, socketSession);
            }
        }
        finally {
            SessionCenter.deleteById(session.getId());
        }
    }

    @OnMessage
    public void onMessage(String message, Session socketChannel) {
        WebSocketMessageDTO WebSocketMessageDTO2 = (WebSocketMessageDTO)JSON.parseObject((String)message, WebSocketMessageDTO.class);
        SocketSession<GunsSocketOperator> socketSession = SessionCenter.getSessionBySessionId(socketChannel.getId());
        if (ObjectUtil.isNotEmpty(socketSession) && ClientMessageTypeEnum.USER_HEART.getCode().equals(WebSocketMessageDTO2.getClientMsgType())) {
            if (ObjectUtil.isNotEmpty(socketSession)) {
                socketSession.setLastActiveTime(Long.valueOf(System.currentTimeMillis()));
            }
            return;
        }
        if (ObjectUtil.isEmpty((Object)WebSocketMessageDTO2.getFormUserId())) {
            return;
        }
        if (ObjectUtil.isNotEmpty(socketSession)) {
            socketSession.setLastActiveTime(Long.valueOf(System.currentTimeMillis()));
            SocketMsgCallbackInterface socketMsgCallbackInterface = SocketMessageCenter.getSocketMsgCallbackInterface(WebSocketMessageDTO2.getClientMsgType());
            if (ObjectUtil.isNotEmpty((Object)socketMsgCallbackInterface)) {
                socketMsgCallbackInterface.callback(WebSocketMessageDTO2.getClientMsgType(), (Object)WebSocketMessageDTO2, socketSession);
            } else {
                socketChannel.getAsyncRemote().sendText("{\"serverMsgType\":\"404\"}");
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        SocketSession<GunsSocketOperator> socketSession = SessionCenter.getSessionBySessionId(session.getId());
        SocketMsgCallbackInterface socketMsgCallbackInterface = SocketMessageCenter.getSocketMsgCallbackInterface(SystemMessageTypeEnum.SYS_LISTENER_ONERROR.getCode());
        if (ObjectUtil.isNotEmpty((Object)socketMsgCallbackInterface)) {
            socketMsgCallbackInterface.callback(SystemMessageTypeEnum.SYS_LISTENER_ONERROR.getCode(), (Object)error, socketSession);
        }
    }
}

