/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.api.enums.user;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.base.ReadableEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.api.exception.SysException;
import cn.stylefeng.roses.kernel.sys.api.exception.enums.UserExceptionEnum;

public enum UserStatusEnum implements ReadableEnum<UserStatusEnum>
{
    ENABLE(1, "\u542f\u7528"),
    DISABLE(2, "\u51bb\u7ed3");

    private final Integer code;
    private final String message;

    private UserStatusEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public static UserStatusEnum toEnum(Integer code) {
        for (UserStatusEnum userStatusEnum : UserStatusEnum.values()) {
            if (!userStatusEnum.getCode().equals(code)) continue;
            return userStatusEnum;
        }
        return null;
    }

    public static String getCodeMessage(Integer code) {
        UserStatusEnum userStatusEnum = UserStatusEnum.toEnum(code);
        if (userStatusEnum != null) {
            return userStatusEnum.getMessage();
        }
        return "";
    }

    public static void validateUserStatus(Integer code) {
        if (code == null) {
            throw new ServiceException((AbstractExceptionEnum)UserExceptionEnum.REQUEST_USER_STATUS_EMPTY);
        }
        if (ENABLE.getCode().equals(code) || DISABLE.getCode().equals(code)) {
            return;
        }
        throw new SysException(UserExceptionEnum.REQUEST_USER_STATUS_ERROR, code);
    }

    public Object getKey() {
        return this.code;
    }

    public Object getName() {
        return this.message;
    }

    public UserStatusEnum parseToEnum(String originValue) {
        if (ObjectUtil.isEmpty((Object)originValue)) {
            return null;
        }
        for (UserStatusEnum value : UserStatusEnum.values()) {
            if (!value.code.equals(Convert.toInt((Object)originValue))) continue;
            return value;
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }
}

