/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.menu.modular.factory;

import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleRoleInfo;
import cn.stylefeng.roses.kernel.menu.modular.entity.SysMenu;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.system.pojo.menu.antd.AntdMenuSelectTreeNode;
import cn.stylefeng.roses.kernel.system.pojo.menu.antd.AntdSysMenuDTO;
import cn.stylefeng.roses.kernel.system.pojo.menu.antd.AntdvMenuAuthorityItem;
import cn.stylefeng.roses.kernel.system.pojo.menu.antd.AntdvMenuItem;
import java.util.ArrayList;
import java.util.List;

public class AntdMenusFactory {
    public static List<AntdvMenuItem> createTotalMenus(List<AntdSysMenuDTO> sysMenuRespons) {
        ArrayList<AntdvMenuItem> antdvMenuItems = new ArrayList<AntdvMenuItem>(sysMenuRespons.size());
        for (AntdSysMenuDTO antdSysMenuDTO : sysMenuRespons) {
            AntdvMenuItem antdvMenuItem = new AntdvMenuItem();
            antdvMenuItem.setMenuId(antdSysMenuDTO.getMenuId());
            antdvMenuItem.setMenuParentId(antdSysMenuDTO.getMenuParentId());
            antdvMenuItem.setName(antdSysMenuDTO.getMenuName());
            antdvMenuItem.setRouter(antdSysMenuDTO.getAntdvRouter());
            antdvMenuItem.setIcon(antdSysMenuDTO.getAntdvIcon());
            antdvMenuItem.setInvisible(Boolean.valueOf(YesOrNotEnum.N.getCode().equals(antdSysMenuDTO.getVisible())));
            List roles = antdSysMenuDTO.getRoles();
            AntdvMenuAuthorityItem antdvAuthorityItem = new AntdvMenuAuthorityItem();
            if (roles != null && roles.size() > 0) {
                ArrayList<String> auths = new ArrayList<String>();
                for (SimpleRoleInfo role : roles) {
                    auths.add(role.getRoleCode());
                }
                antdvAuthorityItem.setPermission(auths);
                antdvAuthorityItem.setRole(auths);
                antdvMenuItem.setAuthority(antdvAuthorityItem);
            }
            antdvMenuItems.add(antdvMenuItem);
        }
        antdvMenuItems.add(AntdMenusFactory.createAntdVMenuRoot());
        return new DefaultTreeBuildFactory(TreeConstants.VIRTUAL_ROOT_PARENT_ID.toString()).doTreeBuild(antdvMenuItems);
    }

    private static AntdvMenuItem createAntdVMenuRoot() {
        AntdvMenuItem antdvMenuItem = new AntdvMenuItem();
        antdvMenuItem.setRouter("root");
        antdvMenuItem.setName("\u6839\u8282\u70b9");
        antdvMenuItem.setMenuId(TreeConstants.DEFAULT_PARENT_ID);
        antdvMenuItem.setMenuParentId(TreeConstants.VIRTUAL_ROOT_PARENT_ID);
        antdvMenuItem.setInvisible(Boolean.valueOf(false));
        antdvMenuItem.setAuthority(null);
        return antdvMenuItem;
    }

    public static AntdMenuSelectTreeNode parseMenuBaseTreeNode(SysMenu sysMenu) {
        AntdMenuSelectTreeNode menuTreeNode = new AntdMenuSelectTreeNode();
        menuTreeNode.setId(sysMenu.getMenuId());
        menuTreeNode.setParentId(sysMenu.getMenuParentId());
        menuTreeNode.setValue(String.valueOf(sysMenu.getMenuId()));
        menuTreeNode.setTitle(sysMenu.getMenuName());
        menuTreeNode.setWeight(sysMenu.getMenuSort());
        return menuTreeNode;
    }
}

