/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.menu.modular.factory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.i18n.api.context.TranslationContext;
import cn.stylefeng.roses.kernel.menu.modular.entity.SysMenu;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import cn.stylefeng.roses.kernel.system.AppServiceApi;
import cn.stylefeng.roses.kernel.system.pojo.menu.layui.LayuiAppIndexMenusVO;
import cn.stylefeng.roses.kernel.system.pojo.menu.layui.LayuiIndexMenuTreeNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LayuiMenusFactory {
    public static List<LayuiAppIndexMenusVO> createLayuiAppIndexMenus(List<SysMenu> sysMenuList) {
        String contextPath = HttpServletUtil.getRequest().getContextPath();
        ArrayList<LayuiAppIndexMenusVO> resultList = new ArrayList<LayuiAppIndexMenusVO>();
        HashSet<String> appCodes = new HashSet<String>();
        for (SysMenu currentUserMenu : sysMenuList) {
            String appCode = currentUserMenu.getAppCode();
            appCodes.add(appCode);
        }
        for (String appCode : appCodes) {
            List appMenus = sysMenuList.stream().filter(i -> i.getAppCode().equals(appCode)).collect(Collectors.toList());
            ArrayList<LayuiIndexMenuTreeNode> layuiIndexMenuTreeNodes = new ArrayList<LayuiIndexMenuTreeNode>();
            for (SysMenu appMenu : appMenus) {
                Map tranDictBook;
                String translatedName;
                LayuiIndexMenuTreeNode layuiIndexMenuTreeNode = new LayuiIndexMenuTreeNode();
                BeanUtil.copyProperties((Object)((Object)appMenu), (Object)layuiIndexMenuTreeNode, (String[])new String[0]);
                layuiIndexMenuTreeNode.setLayuiPath(contextPath + appMenu.getLayuiPath());
                String tranLanguageCode = LoginContext.me().getLoginUser().getTranLanguageCode();
                if (!"chinese".equals(tranLanguageCode) && StrUtil.isNotBlank((CharSequence)(translatedName = (String)(tranDictBook = TranslationContext.me().getTranslationDictByLanguage(tranLanguageCode)).get("MENU_" + appMenu.getMenuCode().toUpperCase())))) {
                    layuiIndexMenuTreeNode.setMenuName(translatedName);
                }
                layuiIndexMenuTreeNodes.add(layuiIndexMenuTreeNode);
            }
            List layuiIndexMenuTreeNodeList = new DefaultTreeBuildFactory().doTreeBuild(layuiIndexMenuTreeNodes);
            LayuiAppIndexMenusVO layuiAppIndexMenusVO = new LayuiAppIndexMenusVO();
            layuiAppIndexMenusVO.setAppCode(appCode);
            layuiAppIndexMenusVO.setAppName(LayuiMenusFactory.getAppNameByAppCode(appCode));
            layuiAppIndexMenusVO.setLayuiIndexMenuTreeNodes(layuiIndexMenuTreeNodeList);
            resultList.add(layuiAppIndexMenusVO);
        }
        return resultList;
    }

    private static String getAppNameByAppCode(String appCode) {
        AppServiceApi appServiceApi = (AppServiceApi)SpringUtil.getBean(AppServiceApi.class);
        return appServiceApi.getAppNameByAppCode(appCode);
    }
}

