/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.menu.factory;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.antd.AntdMenuSelectTreeNode;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.antd.AntdSysMenuDTO;
import cn.stylefeng.roses.kernel.system.modular.menu.entity.SysMenu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class AntdMenusFactory {
    public static List<AntdSysMenuDTO> createTotalMenus(List<SysMenu> sysMenuList) {
        List treeStructMenu = new DefaultTreeBuildFactory(TreeConstants.DEFAULT_PARENT_ID.toString()).doTreeBuild(sysMenuList);
        return AntdMenusFactory.doModelTransfer(treeStructMenu);
    }

    public static AntdMenuSelectTreeNode parseMenuBaseTreeNode(SysMenu sysMenu) {
        AntdMenuSelectTreeNode menuTreeNode = new AntdMenuSelectTreeNode();
        menuTreeNode.setId(sysMenu.getMenuId());
        menuTreeNode.setParentId(sysMenu.getMenuParentId());
        menuTreeNode.setValue(String.valueOf(sysMenu.getMenuId()));
        menuTreeNode.setTitle(sysMenu.getMenuName());
        menuTreeNode.setWeight(sysMenu.getMenuSort());
        return menuTreeNode;
    }

    public static AntdMenuSelectTreeNode createRootNode() {
        AntdMenuSelectTreeNode antdMenuSelectTreeNode = new AntdMenuSelectTreeNode();
        antdMenuSelectTreeNode.setId(Long.valueOf(-1L));
        antdMenuSelectTreeNode.setParentId(Long.valueOf(-2L));
        antdMenuSelectTreeNode.setTitle("\u6839\u8282\u70b9");
        antdMenuSelectTreeNode.setValue(String.valueOf(antdMenuSelectTreeNode.getId()));
        antdMenuSelectTreeNode.setWeight(new BigDecimal(-1));
        return antdMenuSelectTreeNode;
    }

    private static List<AntdSysMenuDTO> doModelTransfer(List<SysMenu> sysMenuList) {
        if (ObjectUtil.isEmpty(sysMenuList)) {
            return null;
        }
        ArrayList<AntdSysMenuDTO> resultMenus = new ArrayList<AntdSysMenuDTO>();
        for (SysMenu sysMenu : sysMenuList) {
            AntdSysMenuDTO antdvMenuItem = new AntdSysMenuDTO();
            antdvMenuItem.setTitle(sysMenu.getMenuName());
            antdvMenuItem.setIcon(sysMenu.getAntdvIcon());
            antdvMenuItem.setPath(sysMenu.getAntdvRouter());
            antdvMenuItem.setComponent(sysMenu.getAntdvComponent());
            antdvMenuItem.setHide(Boolean.valueOf(YesOrNotEnum.N.getCode().equals(sysMenu.getAntdvVisible())));
            antdvMenuItem.setUid(sysMenu.getAntdvUidUrl());
            if (ObjectUtil.isNotEmpty(sysMenu.getChildren())) {
                antdvMenuItem.setChildren(AntdMenusFactory.doModelTransfer(sysMenu.getChildren()));
            }
            resultMenus.add(antdvMenuItem);
        }
        return resultMenus;
    }
}

