/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.menu.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.menu.SysMenuButtonExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.SysMenuButtonRequest;
import cn.stylefeng.roses.kernel.system.modular.menu.entity.SysMenuButton;
import cn.stylefeng.roses.kernel.system.modular.menu.factory.MenuButtonFactory;
import cn.stylefeng.roses.kernel.system.modular.menu.mapper.SysMenuButtonMapper;
import cn.stylefeng.roses.kernel.system.modular.menu.service.SysMenuButtonService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class SysMenuButtonServiceImpl
extends ServiceImpl<SysMenuButtonMapper, SysMenuButton>
implements SysMenuButtonService {
    @Override
    public void add(SysMenuButtonRequest sysMenuButtonRequest) {
        SysMenuButton sysMenuButton = new SysMenuButton();
        BeanUtil.copyProperties((Object)sysMenuButtonRequest, (Object)sysMenuButton, (String[])new String[0]);
        this.save(sysMenuButton);
    }

    @Override
    public void addDefaultButtons(SysMenuButtonRequest sysMenuButtonRequest) {
        Long menuId = sysMenuButtonRequest.getMenuId();
        List<SysMenuButton> sysMenuButtonList = MenuButtonFactory.createSystemDefaultButton(menuId);
        this.saveBatch(sysMenuButtonList);
    }

    @Override
    public void del(SysMenuButtonRequest sysMenuButtonRequest) {
        SysMenuButton button = this.queryButtonById(sysMenuButtonRequest);
        button.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById(button);
    }

    @Override
    public void delBatch(SysMenuButtonRequest sysMenuButtonRequest) {
        Set buttonIds = sysMenuButtonRequest.getButtonIds();
        if (ArrayUtil.isNotEmpty((Object)buttonIds)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysMenuButton::getButtonId, (Collection)buttonIds);
            queryWrapper.eq(SysMenuButton::getDelFlag, (Object)YesOrNotEnum.N.getCode());
            SysMenuButton entity = new SysMenuButton();
            entity.setDelFlag(YesOrNotEnum.Y.getCode());
            this.update(entity, (Wrapper)queryWrapper);
        }
    }

    @Override
    public void edit(SysMenuButtonRequest sysMenuButtonRequest) {
        SysMenuButton button = this.queryButtonById(sysMenuButtonRequest);
        BeanUtil.copyProperties((Object)sysMenuButtonRequest, (Object)button, (String[])new String[0]);
        button.setDelFlag(null);
        button.setMenuId(null);
        button.setButtonCode(null);
        this.updateById(button);
    }

    @Override
    public SysMenuButton detail(SysMenuButtonRequest sysMenuButtonRequest) {
        LambdaQueryWrapper<SysMenuButton> queryWrapper = this.createWrapper(sysMenuButtonRequest);
        return (SysMenuButton)this.getOne((Wrapper)queryWrapper, false);
    }

    @Override
    public PageResult<SysMenuButton> findPage(SysMenuButtonRequest sysMenuButtonRequest) {
        LambdaQueryWrapper<SysMenuButton> wrapper = this.createWrapper(sysMenuButtonRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public void deleteMenuButtonByMenuId(Long menuId) {
        if (ObjectUtil.isNotEmpty((Object)menuId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysMenuButton::getMenuId, (Object)menuId);
            queryWrapper.eq(SysMenuButton::getDelFlag, (Object)YesOrNotEnum.N.getCode());
            SysMenuButton sysMenuButton = new SysMenuButton();
            sysMenuButton.setDelFlag(YesOrNotEnum.Y.getCode());
            this.update(sysMenuButton, (Wrapper)queryWrapper);
        }
    }

    private SysMenuButton queryButtonById(SysMenuButtonRequest sysMenuButtonRequest) {
        SysMenuButton button = (SysMenuButton)this.getById(sysMenuButtonRequest.getButtonId());
        if (ObjectUtil.isNull((Object)button)) {
            throw new SystemModularException((AbstractExceptionEnum)SysMenuButtonExceptionEnum.MENU_BUTTON_NOT_EXIST);
        }
        return button;
    }

    private LambdaQueryWrapper<SysMenuButton> createWrapper(SysMenuButtonRequest sysMenuButtonRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMenuButton::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        if (ObjectUtil.isEmpty((Object)sysMenuButtonRequest)) {
            return queryWrapper;
        }
        Long buttonId = sysMenuButtonRequest.getButtonId();
        Long menuId = sysMenuButtonRequest.getMenuId();
        String buttonName = sysMenuButtonRequest.getButtonName();
        String buttonCode = sysMenuButtonRequest.getButtonCode();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)buttonId), SysMenuButton::getButtonId, (Object)buttonId);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)menuId), SysMenuButton::getMenuId, (Object)menuId);
        queryWrapper.like(ObjectUtil.isNotNull((Object)buttonName), SysMenuButton::getButtonName, (Object)buttonName);
        queryWrapper.like(ObjectUtil.isNotNull((Object)buttonCode), SysMenuButton::getButtonCode, (Object)buttonCode);
        return queryWrapper;
    }
}

