/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.menu.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleRoleInfo;
import cn.stylefeng.roses.kernel.db.api.DbOperatorApi;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.rule.tree.ztree.ZTreeNode;
import cn.stylefeng.roses.kernel.system.api.AppServiceApi;
import cn.stylefeng.roses.kernel.system.api.MenuServiceApi;
import cn.stylefeng.roses.kernel.system.api.RoleServiceApi;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.menu.SysMenuExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.exception.enums.user.SysUserExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.SysMenuRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.antd.AntdMenuSelectTreeNode;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.antd.AntdSysMenuDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.layui.LayuiAppIndexMenusVO;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.layui.LayuiMenuAndButtonTreeResponse;
import cn.stylefeng.roses.kernel.system.api.pojo.role.dto.SysRoleMenuButtonDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.role.dto.SysRoleMenuDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.role.request.SysRoleRequest;
import cn.stylefeng.roses.kernel.system.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.system.modular.menu.entity.SysMenuButton;
import cn.stylefeng.roses.kernel.system.modular.menu.factory.AntdMenusFactory;
import cn.stylefeng.roses.kernel.system.modular.menu.factory.LayuiMenusFactory;
import cn.stylefeng.roses.kernel.system.modular.menu.factory.MenuTypeFactory;
import cn.stylefeng.roses.kernel.system.modular.menu.mapper.SysMenuMapper;
import cn.stylefeng.roses.kernel.system.modular.menu.service.SysMenuButtonService;
import cn.stylefeng.roses.kernel.system.modular.menu.service.SysMenuService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMenuServiceImpl
extends ServiceImpl<SysMenuMapper, SysMenu>
implements SysMenuService,
MenuServiceApi {
    @Resource
    private DbOperatorApi dbOperatorApi;
    @Resource
    private RoleServiceApi roleServiceApi;
    @Resource
    private AppServiceApi appServiceApi;
    @Resource
    private SysMenuButtonService sysMenuButtonService;

    @Override
    public void add(SysMenuRequest sysMenuRequest) {
        if (sysMenuRequest.getMenuParentId() == null) {
            sysMenuRequest.setMenuParentId(TreeConstants.DEFAULT_PARENT_ID);
        } else if (!TreeConstants.DEFAULT_PARENT_ID.equals(sysMenuRequest.getMenuParentId())) {
            SysMenuRequest tempParam = new SysMenuRequest();
            tempParam.setMenuId(sysMenuRequest.getMenuParentId());
            this.querySysMenu(tempParam);
        }
        SysMenu sysMenu = new SysMenu();
        BeanUtil.copyProperties((Object)sysMenuRequest, (Object)((Object)sysMenu), (String[])new String[0]);
        String newPids = this.createPids(sysMenuRequest.getMenuParentId());
        sysMenu.setMenuPids(newPids);
        sysMenu.setStatusFlag(StatusEnum.ENABLE.getCode());
        sysMenu.setDelFlag(YesOrNotEnum.N.getCode());
        MenuTypeFactory.processMenuType(sysMenu, sysMenuRequest.getVisible());
        this.save((Object)sysMenu);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysMenuRequest sysMenuRequest) {
        Long id = sysMenuRequest.getMenuId();
        Set childIdList = this.dbOperatorApi.findSubListByParentId("sys_menu", "menu_pids", "menu_id", id);
        childIdList.add(id);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.in(SysMenu::getMenuId, (Collection)childIdList)).set(SysMenu::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        this.update((Wrapper)updateWrapper);
        this.sysMenuButtonService.deleteMenuButtonByMenuId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(SysMenuRequest sysMenuRequest) {
        SysMenu oldMenu = this.querySysMenu(sysMenuRequest);
        String newPids = this.updateChildrenAppAndLevel(sysMenuRequest, oldMenu);
        BeanUtil.copyProperties((Object)sysMenuRequest, (Object)((Object)oldMenu), (String[])new String[0]);
        oldMenu.setMenuPids(newPids);
        oldMenu.setStatusFlag(null);
        MenuTypeFactory.processMenuType(oldMenu, sysMenuRequest.getVisible());
        this.updateById((Object)oldMenu);
    }

    @Override
    public SysMenu detail(SysMenuRequest sysMenuRequest) {
        SysMenu sysMenu = this.querySysMenu(sysMenuRequest);
        if (sysMenu != null) {
            Long menuParentId = sysMenu.getMenuParentId();
            if (TreeConstants.DEFAULT_PARENT_ID.equals(menuParentId)) {
                sysMenu.setMenuParentName("\u9876\u7ea7");
            } else {
                Long parentId = sysMenu.getMenuParentId();
                SysMenu parentMenu = (SysMenu)((Object)this.getById(parentId));
                if (parentMenu == null) {
                    sysMenu.setMenuParentName("\u65e0");
                } else {
                    sysMenu.setMenuParentName(parentMenu.getMenuName());
                }
            }
        }
        return sysMenu;
    }

    @Override
    public List<SysMenu> findList(SysMenuRequest sysMenuRequest) {
        LambdaQueryWrapper<SysMenu> wrapper = this.createWrapper(sysMenuRequest);
        List list2 = this.list((Wrapper)wrapper);
        HashMap<String, String> appCodeName = new HashMap<String, String>();
        Set appCodeSet = list2.stream().map(SysMenu::getAppCode).collect(Collectors.toSet());
        for (String appCode : appCodeSet) {
            String appName = this.appServiceApi.getAppNameByAppCode(appCode);
            appCodeName.put(appCode, appName);
        }
        for (SysMenu sysMenu : list2) {
            sysMenu.setAppName((String)appCodeName.get(sysMenu.getAppCode()));
        }
        return list2;
    }

    @Override
    public List<SysMenu> findListWithTreeStructure(SysMenuRequest sysMenuRequest) {
        List<SysMenu> sysMenuList = this.findList(sysMenuRequest);
        return new DefaultTreeBuildFactory().doTreeBuild(sysMenuList);
    }

    @Override
    public List<ZTreeNode> layuiSelectParentMenuTreeList() {
        ArrayList<ZTreeNode> zTreeNodes = new ArrayList<ZTreeNode>();
        List allMenus = this.list();
        for (SysMenu sysMenu : allMenus) {
            ZTreeNode zTreeNode = new ZTreeNode();
            zTreeNode.setId(sysMenu.getMenuId());
            zTreeNode.setpId(sysMenu.getMenuParentId());
            zTreeNode.setName(sysMenu.getMenuName());
            zTreeNode.setOpen(Boolean.valueOf(false));
            zTreeNodes.add(zTreeNode);
        }
        zTreeNodes.add(ZTreeNode.createParent());
        return zTreeNodes;
    }

    @Override
    public List<AntdMenuSelectTreeNode> tree(SysMenuRequest sysMenuRequest) {
        ArrayList menuTreeNodeList = CollectionUtil.newArrayList((Object[])new AntdMenuSelectTreeNode[0]);
        AntdMenuSelectTreeNode rootNode = AntdMenusFactory.createRootNode();
        menuTreeNodeList.add(rootNode);
        LambdaQueryWrapper<SysMenu> wrapper = this.createWrapper(sysMenuRequest);
        this.list((Wrapper)wrapper).forEach(sysMenu -> {
            AntdMenuSelectTreeNode menuTreeNode = AntdMenusFactory.parseMenuBaseTreeNode(sysMenu);
            menuTreeNodeList.add(menuTreeNode);
        });
        return new DefaultTreeBuildFactory("-2").doTreeBuild((List)menuTreeNodeList);
    }

    @Override
    public List<LayuiAppIndexMenusVO> getLayuiIndexMenus() {
        List<SysMenu> currentUserMenus = this.getCurrentUserMenus(null, true);
        List<LayuiAppIndexMenusVO> layuiAppIndexMenuVOS = LayuiMenusFactory.createLayuiAppIndexMenus(currentUserMenus);
        String activeAppCode = this.appServiceApi.getActiveAppCode();
        if (activeAppCode != null) {
            List<LayuiAppIndexMenusVO> layuiAppIndexMenusVOArrayList = layuiAppIndexMenuVOS.stream().filter(i -> activeAppCode.equals(i.getAppCode())).collect(Collectors.toList());
            layuiAppIndexMenusVOArrayList.addAll(layuiAppIndexMenuVOS.stream().filter(i -> !activeAppCode.equals(i.getAppCode())).collect(Collectors.toList()));
            return layuiAppIndexMenusVOArrayList;
        }
        return layuiAppIndexMenuVOS;
    }

    @Override
    public List<AntdSysMenuDTO> getLeftMenusAntdv(SysMenuRequest sysMenuRequest) {
        List<SysMenu> currentUserMenus = null;
        if (sysMenuRequest.getTotalMenus() != null && sysMenuRequest.getTotalMenus().booleanValue()) {
            currentUserMenus = this.getCurrentUserMenus(null, false);
        } else {
            String appCode = sysMenuRequest.getAppCode();
            if (ObjectUtil.isEmpty((Object)appCode)) {
                appCode = this.appServiceApi.getActiveAppCode();
            }
            currentUserMenus = this.getCurrentUserMenus(appCode, false);
        }
        return AntdMenusFactory.createTotalMenus(currentUserMenus);
    }

    @Override
    public List<LayuiMenuAndButtonTreeResponse> getMenuAndButtonTree(SysRoleRequest sysRoleRequest, Boolean lateralFlag) {
        List<Long> menuIdList;
        ArrayList menuTreeNodeList = CollectionUtil.newArrayList((Object[])new LayuiMenuAndButtonTreeResponse[0]);
        LambdaQueryWrapper munuWrapper = new LambdaQueryWrapper();
        munuWrapper.eq(SysMenu::getStatusFlag, (Object)StatusEnum.ENABLE.getCode());
        munuWrapper.eq(SysMenu::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        if (!LoginContext.me().getSuperAdminFlag() && !(menuIdList = this.getCurrentUserMenuIds()).isEmpty()) {
            munuWrapper.in(SysMenu::getMenuId, menuIdList);
        }
        List sysMenuList = this.list((Wrapper)munuWrapper);
        List menuList = sysMenuList.parallelStream().map(SysMenu::getMenuId).collect(Collectors.toList());
        LambdaQueryWrapper buttonWrapper = new LambdaQueryWrapper();
        buttonWrapper.eq(SysMenuButton::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        buttonWrapper.in(SysMenuButton::getMenuId, menuList);
        List sysMenuButtons = this.sysMenuButtonService.list((Wrapper)buttonWrapper);
        HashMap buttons = new HashMap(menuList.size());
        for (SysMenuButton menuButton : sysMenuButtons) {
            List buttonList = (List)buttons.get(menuButton.getMenuId());
            if (ObjectUtil.isEmpty((Object)buttonList)) {
                buttonList = new ArrayList();
                buttons.put(menuButton.getMenuId(), buttonList);
            }
            buttonList.add(menuButton);
        }
        List roleMenuList = this.roleServiceApi.getRoleMenuList(Collections.singletonList(sysRoleRequest.getRoleId()));
        HashMap<Long, SysRoleMenuDTO> roleMenuMap = new HashMap<Long, SysRoleMenuDTO>();
        for (SysRoleMenuDTO sysRoleMenuResponse : roleMenuList) {
            roleMenuMap.put(sysRoleMenuResponse.getMenuId(), sysRoleMenuResponse);
        }
        List roleMenuButtonList = this.roleServiceApi.getRoleMenuButtonList(Collections.singletonList(sysRoleRequest.getRoleId()));
        HashMap<Long, SysRoleMenuButtonDTO> roleMenuButtonMap = new HashMap<Long, SysRoleMenuButtonDTO>();
        for (SysRoleMenuButtonDTO buttonResponse : roleMenuButtonList) {
            roleMenuButtonMap.put(buttonResponse.getButtonId(), buttonResponse);
        }
        for (SysMenu sysMenu : sysMenuList) {
            LayuiMenuAndButtonTreeResponse menuTree = new LayuiMenuAndButtonTreeResponse();
            menuTree.setId(sysMenu.getMenuId());
            menuTree.setMenuFlag(Boolean.valueOf(true));
            menuTree.setName(sysMenu.getMenuName());
            menuTree.setPid(sysMenu.getMenuParentId());
            SysRoleMenuDTO roleMenuResponse = (SysRoleMenuDTO)roleMenuMap.get(sysMenu.getMenuId());
            if (ObjectUtil.isEmpty((Object)roleMenuResponse)) {
                menuTree.setChecked(Boolean.valueOf(false));
            } else {
                menuTree.setChecked(Boolean.valueOf(true));
            }
            List menuButtons = (List)buttons.get(sysMenu.getMenuId());
            if (ObjectUtil.isNotEmpty((Object)menuButtons)) {
                for (SysMenuButton menuButton : menuButtons) {
                    LayuiMenuAndButtonTreeResponse buttonTree = new LayuiMenuAndButtonTreeResponse();
                    buttonTree.setName(menuButton.getButtonName());
                    buttonTree.setId(menuButton.getButtonId());
                    buttonTree.setPid(menuButton.getMenuId());
                    buttonTree.setButtonCode(menuButton.getButtonCode());
                    buttonTree.setMenuFlag(Boolean.valueOf(false));
                    SysRoleMenuButtonDTO buttonResponse = (SysRoleMenuButtonDTO)roleMenuButtonMap.get(menuButton.getButtonId());
                    if (ObjectUtil.isNotEmpty((Object)buttonResponse)) {
                        buttonTree.setChecked(Boolean.valueOf(true));
                        menuTree.setChecked(Boolean.valueOf(true));
                    } else {
                        buttonTree.setChecked(Boolean.valueOf(false));
                    }
                    menuTreeNodeList.add(buttonTree);
                }
            }
            menuTreeNodeList.add(menuTree);
        }
        if (lateralFlag.booleanValue()) {
            return menuTreeNodeList;
        }
        return new DefaultTreeBuildFactory().doTreeBuild((List)menuTreeNodeList);
    }

    @Override
    public List<SysMenu> getCurrentUserMenus(String appCode, Boolean layuiVisibleFlag) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysMenu::getStatusFlag, (Object)StatusEnum.ENABLE.getCode())).eq(SysMenu::getDelFlag, (Object)YesOrNotEnum.N.getCode())).orderByAsc(SysMenu::getMenuSort);
        if (StrUtil.isNotBlank((CharSequence)appCode)) {
            queryWrapper.eq(SysMenu::getAppCode, (Object)appCode);
        }
        if (layuiVisibleFlag != null && layuiVisibleFlag.booleanValue()) {
            queryWrapper.eq(SysMenu::getLayuiVisible, (Object)YesOrNotEnum.Y.getCode());
        }
        if (LoginContext.me().getSuperAdminFlag()) {
            return this.list((Wrapper)queryWrapper);
        }
        List<Long> menuIdList = this.getCurrentUserMenuIds();
        if (menuIdList.isEmpty()) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserExceptionEnum.USER_NOT_HAVE_MENUS);
        }
        queryWrapper.in(SysMenu::getMenuId, menuIdList);
        return this.list((Wrapper)queryWrapper);
    }

    public boolean hasMenu(String appCode) {
        SysMenuRequest sysMenuRequest = new SysMenuRequest();
        sysMenuRequest.setAppCode(appCode);
        LambdaQueryWrapper<SysMenu> wrapper = this.createWrapper(sysMenuRequest);
        List list2 = this.list((Wrapper)wrapper);
        return !list2.isEmpty();
    }

    public List<String> getUserAppCodeList() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{SysMenu::getAppCode});
        queryWrapper.groupBy(SysMenu::getAppCode);
        if (!LoginContext.me().getSuperAdminFlag()) {
            List<Long> currentUserMenuIds = this.getCurrentUserMenuIds();
            queryWrapper.in(SysMenu::getMenuId, currentUserMenuIds);
        }
        List list2 = this.list((Wrapper)queryWrapper);
        return list2.stream().map(SysMenu::getAppCode).collect(Collectors.toList());
    }

    public Set<Long> getMenuAllParentMenuId(Set<Long> menuIds) {
        HashSet<Long> parentMenuIds = new HashSet<Long>();
        List sysMenus = this.listByIds(menuIds);
        if (ObjectUtil.isEmpty((Object)sysMenus)) {
            return parentMenuIds;
        }
        for (SysMenu sysMenu : sysMenus) {
            String[] ids;
            String menuPids = sysMenu.getMenuPids().replaceAll("\\[", "").replaceAll("\\]", "");
            for (String id : ids = menuPids.split(",")) {
                parentMenuIds.add(Long.parseLong(id));
            }
        }
        return parentMenuIds;
    }

    private SysMenu querySysMenu(SysMenuRequest sysMenuRequest) {
        SysMenu sysMenu = (SysMenu)((Object)this.getById(sysMenuRequest.getMenuId()));
        if (ObjectUtil.isNull((Object)((Object)sysMenu)) || YesOrNotEnum.Y.getCode().equals(sysMenu.getDelFlag())) {
            throw new SystemModularException((AbstractExceptionEnum)SysMenuExceptionEnum.MENU_NOT_EXIST, new Object[]{sysMenuRequest.getMenuId()});
        }
        return sysMenu;
    }

    private String createPids(Long pid) {
        if (pid.equals(TreeConstants.DEFAULT_PARENT_ID)) {
            return "[" + TreeConstants.DEFAULT_PARENT_ID + "]" + ",";
        }
        SysMenuRequest sysMenuRequest = new SysMenuRequest();
        sysMenuRequest.setMenuId(pid);
        SysMenu parentMenu = this.querySysMenu(sysMenuRequest);
        return parentMenu.getMenuPids() + "[" + pid + "]" + ",";
    }

    private LambdaQueryWrapper<SysMenu> createWrapper(SysMenuRequest sysMenuRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMenu::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        queryWrapper.orderByAsc(SysMenu::getAppCode);
        queryWrapper.orderByAsc(SysMenu::getMenuSort);
        if (ObjectUtil.isEmpty((Object)sysMenuRequest)) {
            return queryWrapper;
        }
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)sysMenuRequest.getAppCode()), SysMenu::getAppCode, (Object)sysMenuRequest.getAppCode());
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)sysMenuRequest.getMenuName()), SysMenu::getMenuName, (Object)sysMenuRequest.getMenuName());
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)sysMenuRequest.getMenuCode()), SysMenu::getMenuCode, (Object)sysMenuRequest.getMenuCode());
        return queryWrapper;
    }

    private List<Long> getCurrentUserMenuIds() {
        LoginUser loginUser = LoginContext.me().getLoginUser();
        List roleIdList = loginUser.getSimpleRoleInfoList().stream().map(SimpleRoleInfo::getRoleId).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(roleIdList)) {
            return CollectionUtil.newArrayList((Object[])new Long[0]);
        }
        List menuIdList = this.roleServiceApi.getMenuIdsByRoleIds(roleIdList);
        if (ObjectUtil.isEmpty((Object)menuIdList)) {
            return CollectionUtil.newArrayList((Object[])new Long[0]);
        }
        return menuIdList;
    }

    private String updateChildrenAppAndLevel(SysMenuRequest sysMenuRequest, SysMenu oldMenu) {
        Long oldPid = oldMenu.getMenuParentId();
        String oldPids = oldMenu.getMenuPids();
        Long newPid = sysMenuRequest.getMenuParentId();
        String newPids = this.createPids(sysMenuRequest.getMenuParentId());
        boolean updateSubAppsFlag = false;
        boolean updateSubPidsFlag = false;
        if (!sysMenuRequest.getAppCode().equals(oldMenu.getAppCode())) {
            if (!oldPid.equals(TreeConstants.DEFAULT_PARENT_ID)) {
                throw new ServiceException((AbstractExceptionEnum)SysMenuExceptionEnum.CANT_MOVE_APP);
            }
            updateSubAppsFlag = true;
        }
        if (!newPid.equals(oldPid)) {
            updateSubPidsFlag = true;
        }
        if (updateSubAppsFlag || updateSubPidsFlag) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.like(SysMenu::getMenuPids, (Object)oldMenu.getMenuId());
            List list2 = this.list((Wrapper)queryWrapper);
            if (ObjectUtil.isNotEmpty((Object)list2)) {
                if (updateSubAppsFlag) {
                    list2.forEach(child -> child.setAppCode(sysMenuRequest.getAppCode()));
                }
                if (updateSubPidsFlag) {
                    list2.forEach(child -> {
                        String oldParentCodesPrefix = oldPids + "[" + oldMenu.getMenuId() + "]" + ",";
                        String oldParentCodesSuffix = child.getMenuPids().substring(oldParentCodesPrefix.length());
                        String menuParentCodes = newPids + "[" + oldMenu.getMenuId() + "]" + "," + oldParentCodesSuffix;
                        child.setMenuPids(menuParentCodes);
                    });
                }
                this.updateBatchById(list2);
            }
        }
        return newPids;
    }
}

