/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.controller;

import cn.stylefeng.roses.kernel.auth.api.AuthServiceApi;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginResponse;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginWithTokenRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.system.api.pojo.login.CurrentUserInfoResponse;
import cn.stylefeng.roses.kernel.system.api.pojo.login.ValidateTokenRequest;
import cn.stylefeng.roses.kernel.system.modular.user.factory.UserLoginInfoFactory;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u767b\u9646\u767b\u51fa\u7ba1\u7406")
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Resource
    private AuthServiceApi authServiceApi;
    @Resource
    private SessionManagerApi sessionManagerApi;

    @PostResource(name="\u767b\u9646", path={"/login"}, requiredLogin=false, requiredPermission=false, responseClass=String.class)
    public ResponseData login(@RequestBody @Validated LoginRequest loginRequest) {
        loginRequest.setCreateCookie(Boolean.valueOf(true));
        LoginResponse loginResponse = this.authServiceApi.login(loginRequest);
        return new SuccessResponseData((Object)loginResponse.getToken());
    }

    @PostResource(name="\u767b\u9646\uff08\u5206\u79bb\u7248\uff09", path={"/loginApi"}, requiredLogin=false, requiredPermission=false, responseClass=LoginResponse.class)
    public ResponseData loginApi(@RequestBody @Validated LoginRequest loginRequest) {
        loginRequest.setCreateCookie(Boolean.valueOf(false));
        LoginResponse loginResponse = this.authServiceApi.login(loginRequest);
        return new SuccessResponseData((Object)loginResponse);
    }

    @PostResource(name="\u9002\u7528\u4e8e\u5355\u70b9\u767b\u5f55", path={"/loginWithToken"}, requiredLogin=false, requiredPermission=false, responseClass=String.class)
    public ResponseData loginWithToken(@RequestBody @Validated LoginWithTokenRequest loginWithTokenRequest) {
        LoginResponse loginResponse = this.authServiceApi.LoginWithToken(loginWithTokenRequest);
        return new SuccessResponseData((Object)loginResponse.getToken());
    }

    @ApiResource(name="\u767b\u51fa", path={"/logoutAction"}, requiredPermission=false, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData logoutAction() {
        this.authServiceApi.logout();
        return new SuccessResponseData();
    }

    @GetResource(name="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u7528\u6237\u4fe1\u606f", path={"/getCurrentLoginUserInfo"}, requiredPermission=false, responseClass=CurrentUserInfoResponse.class)
    public ResponseData getCurrentLoginUserInfo() {
        LoginUser loginUser = LoginContext.me().getLoginUser();
        CurrentUserInfoResponse currentUserInfoResponse = UserLoginInfoFactory.parseUserInfo(loginUser);
        return new SuccessResponseData((Object)currentUserInfoResponse);
    }

    @PostResource(name="\u6821\u9a8ctoken\u662f\u5426\u6b63\u786e", path={"/validateToken"}, requiredPermission=false, requiredLogin=false)
    public ResponseData validateToken(@RequestBody @Valid ValidateTokenRequest validateTokenRequest) {
        boolean haveSessionFlag = this.sessionManagerApi.haveSession(validateTokenRequest.getToken());
        return new SuccessResponseData((Object)haveSessionFlag);
    }
}

