/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.user.SysUserDataScopeExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.user.request.SysUserRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.user.request.UserDataScopeRequest;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserDataScope;
import cn.stylefeng.roses.kernel.system.modular.user.mapper.SysUserDataScopeMapper;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserDataScopeService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserDataScopeServiceImpl
extends ServiceImpl<SysUserDataScopeMapper, SysUserDataScope>
implements SysUserDataScopeService {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void assignData(SysUserRequest sysUserRequest) {
        Long userId = sysUserRequest.getUserId();
        this.delByUserId(userId);
        List orgIds = sysUserRequest.getGrantOrgIdList();
        ArrayList sysUserDataScopeList = CollUtil.newArrayList((Object[])new SysUserDataScope[0]);
        orgIds.forEach(orgId -> {
            SysUserDataScope sysUserDataScope = new SysUserDataScope();
            sysUserDataScope.setUserId(userId);
            sysUserDataScope.setOrgId((Long)orgId);
            sysUserDataScopeList.add(sysUserDataScope);
        });
        this.saveBatch(sysUserDataScopeList);
    }

    @Override
    public void add(UserDataScopeRequest userDataScopeRequest) {
        SysUserDataScope sysUserDataScope = new SysUserDataScope();
        BeanUtil.copyProperties((Object)userDataScopeRequest, (Object)((Object)sysUserDataScope), (String[])new String[0]);
        this.save((Object)sysUserDataScope);
    }

    @Override
    public void del(UserDataScopeRequest userDataScopeRequest) {
        SysUserDataScope sysUserDataScope = this.querySysUserRoleById(userDataScopeRequest);
        this.removeById(sysUserDataScope.getUserDataScopeId());
    }

    @Override
    public void delByUserId(Long userId) {
        if (ObjectUtil.isNotEmpty((Object)userId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysUserDataScope::getUserId, (Object)userId);
            this.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    public void edit(UserDataScopeRequest userDataScopeRequest) {
        SysUserDataScope sysUserDataScope = this.querySysUserRoleById(userDataScopeRequest);
        BeanUtil.copyProperties((Object)((Object)sysUserDataScope), (Object)userDataScopeRequest, (String[])new String[0]);
        this.updateById((Object)sysUserDataScope);
    }

    @Override
    public SysUserDataScope detail(UserDataScopeRequest userDataScopeRequest) {
        return (SysUserDataScope)((Object)this.getOne((Wrapper)this.createQueryWrapper(userDataScopeRequest), false));
    }

    @Override
    public List<Long> findOrgIdsByUserId(Long uerId) {
        UserDataScopeRequest userDataScopeRequest = new UserDataScopeRequest();
        userDataScopeRequest.setUserId(uerId);
        List<SysUserDataScope> sysUserDataScopeList = this.findList(userDataScopeRequest);
        return sysUserDataScopeList.stream().map(SysUserDataScope::getOrgId).collect(Collectors.toList());
    }

    @Override
    public List<SysUserDataScope> findList(UserDataScopeRequest userDataScopeRequest) {
        LambdaQueryWrapper<SysUserDataScope> queryWrapper = this.createQueryWrapper(userDataScopeRequest);
        return this.list((Wrapper)queryWrapper);
    }

    private SysUserDataScope querySysUserRoleById(UserDataScopeRequest userDataScopeRequest) {
        SysUserDataScope sysUserDataScope = (SysUserDataScope)((Object)this.getById(userDataScopeRequest.getUserDataScopeId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysUserDataScope))) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserDataScopeExceptionEnum.USER_DATA_SCOPE_NOT_EXIST, new Object[]{sysUserDataScope.getUserDataScopeId()});
        }
        return sysUserDataScope;
    }

    private LambdaQueryWrapper<SysUserDataScope> createQueryWrapper(UserDataScopeRequest userDataScopeRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userDataScopeRequest.getOrgId()), SysUserDataScope::getOrgId, (Object)userDataScopeRequest.getOrgId());
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userDataScopeRequest.getUserId()), SysUserDataScope::getUserId, (Object)userDataScopeRequest.getUserId());
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userDataScopeRequest.getUserDataScopeId()), SysUserDataScope::getUserDataScopeId, (Object)userDataScopeRequest.getUserDataScopeId());
        return queryWrapper;
    }
}

