/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.system.api.pojo.user.request.SysUserRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.user.request.UserRoleRequest;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserRole;
import cn.stylefeng.roses.kernel.system.modular.user.mapper.SysUserRoleMapper;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserRoleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserRoleServiceImpl
extends ServiceImpl<SysUserRoleMapper, SysUserRole>
implements SysUserRoleService {
    @Resource(name="userRoleCacheApi")
    private CacheOperatorApi<List<Long>> userRoleCacheApi;

    @Override
    public void add(UserRoleRequest userRoleRequest) {
        SysUserRole sysUserRole = new SysUserRole();
        BeanUtil.copyProperties((Object)userRoleRequest, (Object)((Object)sysUserRole), (String[])new String[0]);
        this.save((Object)sysUserRole);
    }

    @Override
    public void del(UserRoleRequest userRoleRequest) {
        SysUserRole sysUserRole = this.querySysUserRoleById(userRoleRequest);
        this.removeById(sysUserRole.getUserRoleId());
    }

    @Override
    public void delByUserId(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserRole::getUserId, (Object)userId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void edit(UserRoleRequest userRoleRequest) {
        SysUserRole sysUserRole = this.querySysUserRoleById(userRoleRequest);
        BeanUtil.copyProperties((Object)userRoleRequest, (Object)((Object)sysUserRole), (String[])new String[0]);
        this.updateById((Object)sysUserRole);
    }

    @Override
    public SysUserRole detail(UserRoleRequest userRoleRequest) {
        LambdaQueryWrapper<SysUserRole> queryWrapper = this.createQueryWrapper(userRoleRequest);
        return (SysUserRole)((Object)this.getOne((Wrapper)queryWrapper, false));
    }

    @Override
    public List<SysUserRole> findList(UserRoleRequest userRoleRequest) {
        LambdaQueryWrapper<SysUserRole> queryWrapper = this.createQueryWrapper(userRoleRequest);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SysUserRole> findListByUserId(Long userId) {
        UserRoleRequest userRoleRequest = new UserRoleRequest();
        userRoleRequest.setUserId(userId);
        return this.findList(userRoleRequest);
    }

    @Override
    public List<Long> findRoleIdsByUserId(Long userId) {
        String key = String.valueOf(userId);
        List userRolesCache = (List)this.userRoleCacheApi.get(key);
        if (userRolesCache != null) {
            return userRolesCache;
        }
        UserRoleRequest userRoleRequest = new UserRoleRequest();
        userRoleRequest.setUserId(userId);
        List<SysUserRole> sysUserRoleList = this.findList(userRoleRequest);
        List<Long> userRoles = sysUserRoleList.stream().map(SysUserRole::getRoleId).collect(Collectors.toList());
        this.userRoleCacheApi.put(key, userRoles);
        return userRoles;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void assignRoles(SysUserRequest sysUserRequest) {
        Long userId = sysUserRequest.getUserId();
        this.delByUserId(userId);
        List rileIds = sysUserRequest.getGrantRoleIdList();
        ArrayList sysUserRoleList = CollUtil.newArrayList((Object[])new SysUserRole[0]);
        rileIds.forEach(roleId -> {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(userId);
            sysUserRole.setRoleId((Long)roleId);
            sysUserRoleList.add(sysUserRole);
        });
        this.saveBatch(sysUserRoleList);
        this.userRoleCacheApi.remove(new String[]{String.valueOf(userId)});
    }

    private SysUserRole querySysUserRoleById(UserRoleRequest userRoleRequest) {
        return (SysUserRole)((Object)this.getById(userRoleRequest.getUserRoleId()));
    }

    private LambdaQueryWrapper<SysUserRole> createQueryWrapper(UserRoleRequest userRoleRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userRoleRequest.getUserRoleId()), SysUserRole::getUserRoleId, (Object)userRoleRequest.getUserRoleId());
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userRoleRequest.getUserId()), SysUserRole::getUserId, (Object)userRoleRequest.getUserId());
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userRoleRequest.getRoleId()), SysUserRole::getRoleId, (Object)userRoleRequest.getRoleId());
        return queryWrapper;
    }
}

