/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.factory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleRoleInfo;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleUserInfo;
import cn.stylefeng.roses.kernel.auth.api.prop.LoginUserPropExpander;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.system.api.enums.AntdvFrontTypeEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.login.CurrentUserInfoResponse;
import cn.stylefeng.roses.kernel.system.api.pojo.organization.DataScopeDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.role.dto.SysRoleDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserOrgDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.UserLoginInfoDTO;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUser;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UserLoginInfoFactory {
    public static UserLoginInfoDTO userLoginInfoDTO(SysUser sysUser, List<SysRoleDTO> roleResponseList, DataScopeDTO dataScopeResponse, SysUserOrgDTO userOrgInfo, Set<String> resourceUrlsListByCodes, Set<String> roleButtonCodes, AntdvFrontTypeEnum userMenuType) {
        UserLoginInfoDTO userLoginInfoDTO = new UserLoginInfoDTO();
        userLoginInfoDTO.setUserPasswordHexed(sysUser.getPassword());
        userLoginInfoDTO.setUserStatus(sysUser.getStatusFlag());
        LoginUser loginUser = new LoginUser();
        loginUser.setAccount(sysUser.getAccount());
        loginUser.setUserId(sysUser.getUserId());
        loginUser.setSuperAdmin(Boolean.valueOf(YesOrNotEnum.Y.getCode().equals(sysUser.getSuperAdminFlag())));
        SimpleUserInfo simpleUserInfo = new SimpleUserInfo();
        BeanUtil.copyProperties((Object)((Object)sysUser), (Object)simpleUserInfo, (String[])new String[0]);
        loginUser.setSimpleUserInfo(simpleUserInfo);
        if (!roleResponseList.isEmpty()) {
            ArrayList<SimpleRoleInfo> simpleRoleInfos = new ArrayList<SimpleRoleInfo>();
            for (SysRoleDTO sysRoleDTO : roleResponseList) {
                SimpleRoleInfo simpleRoleInfo = new SimpleRoleInfo();
                BeanUtil.copyProperties((Object)sysRoleDTO, (Object)simpleRoleInfo, (String[])new String[0]);
                simpleRoleInfos.add(simpleRoleInfo);
            }
            loginUser.setSimpleRoleInfoList(simpleRoleInfos);
        }
        if (userOrgInfo != null) {
            loginUser.setOrganizationId(userOrgInfo.getOrgId());
            loginUser.setPositionId(userOrgInfo.getPositionId());
        }
        if (dataScopeResponse != null) {
            loginUser.setDataScopeTypeEnums(dataScopeResponse.getDataScopeTypeEnums());
            loginUser.setDataScopeOrganizationIds(dataScopeResponse.getOrganizationIds());
            loginUser.setDataScopeUserIds(dataScopeResponse.getUserIds());
        }
        loginUser.setResourceUrls(resourceUrlsListByCodes);
        Map beansOfLoginUserExpander = SpringUtil.getBeansOfType(LoginUserPropExpander.class);
        if (beansOfLoginUserExpander != null && beansOfLoginUserExpander.size() > 0) {
            for (Map.Entry entry : beansOfLoginUserExpander.entrySet()) {
                ((LoginUserPropExpander)entry.getValue()).expandAction(loginUser);
            }
        }
        loginUser.setButtonCodes(roleButtonCodes);
        loginUser.setLoginTime(new Date());
        loginUser.setMenuType(userMenuType.getCode());
        userLoginInfoDTO.setLoginUser(loginUser);
        return userLoginInfoDTO;
    }

    public static CurrentUserInfoResponse parseUserInfo(LoginUser loginUser) {
        SysUserService sysUserService = (SysUserService)SpringUtil.getBean(SysUserService.class);
        CurrentUserInfoResponse currentUserInfoResponse = new CurrentUserInfoResponse();
        currentUserInfoResponse.setUserId(loginUser.getUserId());
        currentUserInfoResponse.setOrganizationId(loginUser.getOrganizationId());
        currentUserInfoResponse.setWsUrl(loginUser.getWsUrl());
        currentUserInfoResponse.setNickname(loginUser.getSimpleUserInfo().getNickName());
        currentUserInfoResponse.setRealName(loginUser.getSimpleUserInfo().getRealName());
        Long avatarFileId = loginUser.getSimpleUserInfo().getAvatar();
        String userAvatarUrl = sysUserService.getUserAvatarUrl(avatarFileId, loginUser.getToken());
        currentUserInfoResponse.setAvatar(userAvatarUrl);
        List simpleRoleInfoList = loginUser.getSimpleRoleInfoList();
        Set roleCodes = simpleRoleInfoList.stream().map(SimpleRoleInfo::getRoleCode).collect(Collectors.toSet());
        currentUserInfoResponse.setRoles(roleCodes);
        currentUserInfoResponse.setAuthorities(loginUser.getButtonCodes());
        return currentUserInfoResponse;
    }
}

