/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.enums.ResBizTypeEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.system.api.RoleServiceApi;
import cn.stylefeng.roses.kernel.system.api.pojo.role.dto.SysRoleDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.role.request.SysRoleRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserAdminDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.request.SysAdminRequest;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUser;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserRole;
import cn.stylefeng.roses.kernel.system.modular.user.mapper.SysUserRoleMapper;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserAdminService;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserRoleService;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysUserAdminServiceImpl
implements SysUserAdminService {
    @Resource
    private RoleServiceApi roleServiceApi;
    @Resource
    private SysUserRoleService sysUserRoleService;
    @Resource
    private SysUserService sysUserService;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;

    @Override
    public List<SysUserAdminDTO> getAdminUserList() {
        SysRoleRequest sysRoleRequest = new SysRoleRequest();
        sysRoleRequest.setAdminFlag(YesOrNotEnum.Y.getCode());
        List roleSelectList = this.roleServiceApi.getRoleSelectList(sysRoleRequest);
        List adminRoleIds = roleSelectList.stream().map(SysRoleDTO::getRoleId).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(adminRoleIds)) {
            return new ArrayList<SysUserAdminDTO>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUserRole::getRoleId, adminRoleIds);
        List sysUserRoleList = this.sysUserRoleService.list((Wrapper)queryWrapper);
        List userIdList = sysUserRoleList.stream().map(SysUserRole::getUserId).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(userIdList)) {
            return new ArrayList<SysUserAdminDTO>();
        }
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserLambdaQueryWrapper.select(new SFunction[]{SysUser::getUserId, SysUser::getRealName});
        sysUserLambdaQueryWrapper.in(SysUser::getUserId, userIdList);
        sysUserLambdaQueryWrapper.ne(SysUser::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        List userList = this.sysUserService.list((Wrapper)sysUserLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)userList)) {
            return new ArrayList<SysUserAdminDTO>();
        }
        ArrayList<SysUserAdminDTO> sysUserAdminDTOS = new ArrayList<SysUserAdminDTO>();
        Map<Long, List<SysUserRole>> userIdRoles = sysUserRoleList.stream().collect(Collectors.groupingBy(SysUserRole::getUserId));
        for (SysUser sysUser : userList) {
            SysUserAdminDTO sysUserAdminDTO = new SysUserAdminDTO();
            sysUserAdminDTO.setUserId(sysUser.getUserId());
            List<SysUserRole> userRoles = userIdRoles.get(sysUser.getUserId());
            if (userRoles != null && userRoles.size() > 0) {
                sysUserAdminDTO.setRoleId(userRoles.get(0).getRoleId());
            }
            sysUserAdminDTO.setRealName(sysUser.getRealName());
            sysUserAdminDTOS.add(sysUserAdminDTO);
        }
        return sysUserAdminDTOS;
    }

    @Override
    public void addAdminUser(SysAdminRequest sysAdminRequest) {
        List<SysUserRole> sysUserRoleList = this.sysUserRoleMapper.getAdminUserRoleList(sysAdminRequest.getUserIdList());
        Set haveAlreadyBindUserIds = sysUserRoleList.stream().map(SysUserRole::getUserId).collect(Collectors.toSet());
        for (Long userId : sysAdminRequest.getUserIdList()) {
            if (haveAlreadyBindUserIds.contains(userId)) continue;
            this.addSingleAdminUser(userId);
        }
    }

    @Override
    public void deleteAdminUser(SysAdminRequest sysAdminRequest) {
        List<SysUserRole> userRoleList = this.sysUserRoleMapper.getAdminUserRoleList(ListUtil.toList((Object[])new Long[]{sysAdminRequest.getUserId()}));
        for (SysUserRole sysUserRole : userRoleList) {
            SysRoleRequest sysRoleRequest = new SysRoleRequest();
            sysRoleRequest.setRoleId(sysUserRole.getRoleId());
            this.roleServiceApi.del(sysRoleRequest);
        }
    }

    private void addSingleAdminUser(Long userId) {
        SysUser user = (SysUser)((Object)this.sysUserService.getById(userId));
        if (user == null) {
            return;
        }
        SysRoleRequest sysRoleRequest = new SysRoleRequest();
        sysRoleRequest.setRoleId(Long.valueOf(IdWorker.getId()));
        sysRoleRequest.setRoleName("\u7ba1\u7406\u5458\u6743\u9650-" + userId);
        sysRoleRequest.setRoleCode("admin-" + userId);
        this.roleServiceApi.addAdminRole(sysRoleRequest);
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setUserId(userId);
        sysUserRole.setRoleId(sysRoleRequest.getRoleId());
        this.sysUserRoleService.save((Object)sysUserRole);
        SysRoleRequest temp = new SysRoleRequest();
        temp.setRoleId(sysRoleRequest.getRoleId());
        temp.setTotalSelectFlag(Boolean.valueOf(true));
        this.roleServiceApi.grantButtonGrantAll(temp);
        SysRoleRequest tempResRequest = new SysRoleRequest();
        tempResRequest.setRoleId(sysRoleRequest.getRoleId());
        tempResRequest.setTotalSelectFlag(Boolean.valueOf(true));
        tempResRequest.setResourceBizType(ResBizTypeEnum.SYSTEM.getCode());
        this.roleServiceApi.grantResourceV2GrantAll(tempResRequest);
    }
}

