/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.integration.core.tag;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDict;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDictType;
import cn.stylefeng.roses.kernel.system.integration.core.tag.SysDictBaseTag;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysDictCheckBoxTag
extends SysDictBaseTag {
    private static final Logger log = LoggerFactory.getLogger(SysDictCheckBoxTag.class);

    @Override
    public void render() {
        SysDictType dictType;
        this.initAttr();
        StringBuilder sb = new StringBuilder();
        if (StrUtil.isNotBlank((CharSequence)this.getDictTypeCode()) && (dictType = this.getDictType()) != null) {
            List<SysDict> lst = this.getDictList();
            String defaultValue = this.getDefaultValue();
            for (SysDict option : lst) {
                String id = this.getType() + "_" + this.getName() + "_" + option.getDictCode();
                sb.append(" <input type='checkbox' name='").append(this.getName()).append("' id='").append(id).append("' title='").append(option.getDictName()).append("' value='").append(option.getDictCode()).append("'");
                if (StrUtil.isNotBlank((CharSequence)this.getLaySkin())) {
                    sb.append(" lay-skin='").append(this.getLaySkin()).append("'");
                }
                if (StrUtil.isNotBlank((CharSequence)this.getLayFilter())) {
                    sb.append(" lay-filter='").append(this.getLayFilter()).append("'");
                }
                if (StrUtil.isNotBlank((CharSequence)this.getLayVerify())) {
                    sb.append(" lay-verify='").append(this.getLayVerify()).append("'");
                }
                if (StrUtil.isNotBlank((CharSequence)defaultValue) && defaultValue.equals(option.getDictCode())) {
                    sb.append(" checked ");
                }
                sb.append(" /> ");
            }
        }
        try {
            this.ctx.byteWriter.writeString(sb.toString());
        }
        catch (IOException e) {
            log.error("checkbox\u5b57\u5178\u521d\u59cb\u5316\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

