/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.integration.core.tag;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDict;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDictType;
import cn.stylefeng.roses.kernel.system.integration.core.enums.SelectTagHeadTypeEnum;
import cn.stylefeng.roses.kernel.system.integration.core.tag.SysDictBaseTag;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysDictSelectTag
extends SysDictBaseTag {
    private static final Logger log = LoggerFactory.getLogger(SysDictSelectTag.class);

    @Override
    public void render() {
        this.initAttr();
        StringBuilder sb = new StringBuilder();
        if (StrUtil.isNotBlank((CharSequence)this.getDictTypeCode())) {
            sb.append("<select name='").append(this.getName()).append("' id='").append(this.getId()).append("'");
            if (StrUtil.isNotBlank((CharSequence)this.getLayFilter())) {
                sb.append(" lay-filter='").append(this.getLayFilter()).append("' ");
            }
            if (StrUtil.isNotBlank((CharSequence)this.getLayVerify())) {
                sb.append(" lay-verify='").append(this.getLayVerify()).append("' ");
            }
            if (StrUtil.isNotBlank((CharSequence)this.getWorkflowForm())) {
                sb.append(" workFlowForm='").append(this.getWorkflowForm()).append("' ");
            }
            if (StrUtil.isNotBlank((CharSequence)this.getItemName())) {
                sb.append(" itemName='").append(this.getItemName()).append("' ");
            }
            sb.append(" >");
            if (StrUtil.isNotBlank((CharSequence)this.getHeadName())) {
                sb.append("<option value='").append(this.getHeadValue()).append("' selected>").append(this.getHeadName()).append("</option>");
            } else if (StrUtil.isNotBlank((CharSequence)this.getHeadType())) {
                if (SelectTagHeadTypeEnum.ALL.getCode().equals(this.getHeadType())) {
                    sb.append("<option value='").append(this.getHeadValue()).append("' selected>").append(" - \u5168\u90e8 - ").append("</option>");
                }
                if (SelectTagHeadTypeEnum.SELECT.getCode().equals(this.getHeadType())) {
                    sb.append("<option value='").append(this.getHeadValue()).append("' selected>").append(" - \u8bf7\u9009\u62e9 - ").append("</option>");
                }
            }
            SysDictType dictType = this.getDictType();
            if (dictType != null) {
                List<SysDict> lst = this.getDictList();
                String defaultValue = this.getDefaultValue();
                int index = 0;
                for (SysDict option : lst) {
                    sb.append("<option value='").append(option.getDictCode()).append("'");
                    if (StrUtil.isNotBlank((CharSequence)defaultValue) && defaultValue.equals(option.getDictCode())) {
                        sb.append(" selected ");
                    } else if (index == 0 && StrUtil.isNotBlank((CharSequence)this.getHeadName()) && StrUtil.isNotBlank((CharSequence)this.getHeadType())) {
                        sb.append(" selected ");
                    }
                    sb.append(">").append(option.getDictName()).append("</option>");
                    ++index;
                }
            }
            sb.append("</select>");
        }
        try {
            this.ctx.byteWriter.writeString(sb.toString());
        }
        catch (IOException e) {
            log.error("select\u5b57\u5178\u521d\u59cb\u5316\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

