/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.integration.modular.system.index.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleRoleInfo;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleUserInfo;
import cn.stylefeng.roses.kernel.message.api.MessageApi;
import cn.stylefeng.roses.kernel.message.api.enums.MessageReadFlagEnum;
import cn.stylefeng.roses.kernel.message.api.pojo.request.MessageRequest;
import cn.stylefeng.roses.kernel.system.modular.menu.service.SysMenuService;
import cn.stylefeng.roses.kernel.system.modular.organization.entity.HrOrganization;
import cn.stylefeng.roses.kernel.system.modular.organization.service.HrOrganizationService;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class IndexService {
    @Resource
    private SysMenuService sysMenuService;
    @Resource
    private SysUserService sysUserService;
    @Resource
    private HrOrganizationService hrOrganizationService;
    @Resource
    private MessageApi messageApi;

    public Map<String, Object> createIndexRenderAttributes() {
        HashMap<String, Object> renderMap = new HashMap<String, Object>();
        LoginUser loginUser = LoginContext.me().getLoginUser();
        SimpleUserInfo simpleUserInfo = loginUser.getSimpleUserInfo();
        List layuiAppIndexMenus = this.sysMenuService.getLayuiIndexMenus();
        renderMap.put("layuiAppIndexMenus", layuiAppIndexMenus);
        renderMap.put("avatar", this.sysUserService.getUserAvatarUrl(simpleUserInfo.getAvatar()));
        renderMap.put("name", simpleUserInfo.getRealName());
        renderMap.put("wsUrl", loginUser.getWsUrl());
        renderMap.put("userId", loginUser.getUserId());
        MessageRequest messageRequest = new MessageRequest();
        messageRequest.setReadFlag(MessageReadFlagEnum.UNREAD.getCode());
        renderMap.put("msgUnReadCount", this.messageApi.queryCountCurrentUser(messageRequest));
        return renderMap;
    }

    public Map<String, Object> createPersonInfoRenderAttributes() {
        Long organizationId;
        HrOrganization hrOrganization;
        HashMap<String, Object> renderMap = new HashMap<String, Object>();
        renderMap.put("roleName", "\u89d2\u8272\u7a7a");
        renderMap.put("orgName", "\u7ec4\u7ec7\u67b6\u6784\u7a7a");
        LoginUser loginUser = LoginContext.me().getLoginUser();
        SimpleUserInfo simpleUserInfo = loginUser.getSimpleUserInfo();
        renderMap.putAll(BeanUtil.beanToMap((Object)simpleUserInfo, (String[])new String[0]));
        List simpleRoleInfoList = loginUser.getSimpleRoleInfoList();
        if (ObjectUtil.isNotEmpty((Object)simpleRoleInfoList)) {
            String roleName = ((SimpleRoleInfo)simpleRoleInfoList.get(0)).getRoleName();
            renderMap.put("roleName", roleName);
        }
        if ((hrOrganization = (HrOrganization)this.hrOrganizationService.getById((Serializable)(organizationId = loginUser.getOrganizationId()))) != null) {
            renderMap.put("orgName", hrOrganization.getOrgName());
        }
        renderMap.put("avatar", this.sysUserService.getUserAvatarUrl(simpleUserInfo.getAvatar()));
        return renderMap;
    }
}

