/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.starter;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.system.api.constants.StatisticsCacheConstants;
import cn.stylefeng.roses.kernel.system.api.constants.SystemCachesConstants;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserOrgDTO;
import cn.stylefeng.roses.kernel.system.modular.home.cache.InterfaceStatisticsMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.role.cache.RoleDataScopeMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.role.cache.RoleMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.role.cache.RoleResourceMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.role.entity.SysRole;
import cn.stylefeng.roses.kernel.system.modular.theme.cache.ThemeMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.theme.pojo.DefaultTheme;
import cn.stylefeng.roses.kernel.system.modular.user.cache.SysUserMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.user.cache.UserOrgMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.user.cache.UserRoleMemoryCache;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GunsSystemCacheAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"sysUserCacheOperatorApi"})
    public CacheOperatorApi<SysUserDTO> sysUserCacheOperatorApi() {
        TimedCache sysUserTimedCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new SysUserMemoryCache(sysUserTimedCache);
    }

    @Bean
    @ConditionalOnMissingBean(name={"userRoleCacheApi"})
    public CacheOperatorApi<List<Long>> userRoleCacheApi() {
        TimedCache userRoleCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new UserRoleMemoryCache(userRoleCache);
    }

    @Bean
    @ConditionalOnMissingBean(name={"roleInfoCacheApi"})
    public CacheOperatorApi<SysRole> roleInfoCacheApi() {
        TimedCache roleCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new RoleMemoryCache(roleCache);
    }

    @Bean
    @ConditionalOnMissingBean(name={"userOrgCacheApi"})
    public CacheOperatorApi<SysUserOrgDTO> userOrgCacheApi() {
        TimedCache roleCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new UserOrgMemoryCache(roleCache);
    }

    @Bean
    @ConditionalOnMissingBean(name={"roleResourceCacheApi"})
    public CacheOperatorApi<List<String>> roleResourceCacheApi() {
        TimedCache roleCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new RoleResourceMemoryCache(roleCache);
    }

    @Bean
    @ConditionalOnMissingBean(name={"roleDataScopeCacheApi"})
    public CacheOperatorApi<List<Long>> roleDataScopeCacheApi() {
        TimedCache roleCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new RoleDataScopeMemoryCache(roleCache);
    }

    @Bean
    @ConditionalOnMissingBean(name={"themeCacheApi"})
    public CacheOperatorApi<DefaultTheme> themeCacheApi() {
        TimedCache themeCache = CacheUtil.newTimedCache((long)Long.MAX_VALUE);
        return new ThemeMemoryCache(themeCache);
    }

    @Bean
    @ConditionalOnMissingBean(name={"requestCountCacheApi"})
    public CacheOperatorApi<Map<Long, Integer>> requestCountCacheApi() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)StatisticsCacheConstants.INTERFACE_STATISTICS_CACHE_TIMEOUT_SECONDS);
        return new InterfaceStatisticsMemoryCache(timedCache);
    }
}

