/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.wrapper.field.simple;

import cn.stylefeng.roses.kernel.rule.base.SimpleFieldFormatProcess;
import cn.stylefeng.roses.kernel.rule.enums.FormatTypeEnum;
import cn.stylefeng.roses.kernel.wrapper.field.util.CommonFormatUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFieldFormatSerializer
extends JsonSerializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(SimpleFieldFormatSerializer.class);
    private final FormatTypeEnum formatTypeEnum;
    private final Class<? extends SimpleFieldFormatProcess> processClass;

    public SimpleFieldFormatSerializer(FormatTypeEnum formatTypeEnum, Class<? extends SimpleFieldFormatProcess> processClass) {
        this.formatTypeEnum = formatTypeEnum;
        this.processClass = processClass;
    }

    public void serialize(Object originValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        try {
            this.action(originValue, jsonGenerator, serializerProvider);
        }
        catch (Exception e) {
            log.error("\u6267\u884cjson\u7684\u5b57\u6bb5\u5e8f\u5217\u5316\u51fa\u9519", (Throwable)e);
            jsonGenerator.writeObject(originValue);
        }
    }

    private void action(Object originValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws InstantiationException, IllegalAccessException, IOException {
        SimpleFieldFormatProcess simpleFieldFormatProcess = this.processClass.newInstance();
        boolean canFormat = simpleFieldFormatProcess.canFormat(originValue);
        if (!canFormat) {
            jsonGenerator.writeObject(originValue);
            return;
        }
        Object formattedValue = simpleFieldFormatProcess.formatProcess(originValue);
        CommonFormatUtil.writeField(this.formatTypeEnum, originValue, formattedValue, jsonGenerator);
    }
}

