/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.wrapper;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.util.ObjectConvertUtil;
import cn.stylefeng.roses.kernel.wrapper.api.BaseWrapper;
import cn.stylefeng.roses.kernel.wrapper.api.annotation.Wrapper;
import cn.stylefeng.roses.kernel.wrapper.api.exception.WrapperException;
import cn.stylefeng.roses.kernel.wrapper.api.exception.enums.WrapperExceptionEnum;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class WrapperAop {
    private static final Logger log = LoggerFactory.getLogger(WrapperAop.class);

    @Pointcut(value="@annotation(cn.stylefeng.roses.kernel.wrapper.api.annotation.Wrapper)")
    private void wrapperPointcut() {
    }

    @Around(value="wrapperPointcut()")
    public Object doWrapper(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object proceedResult = proceedingJoinPoint.proceed();
        return this.processWrapping(proceedingJoinPoint, proceedResult);
    }

    private Object processWrapping(ProceedingJoinPoint proceedingJoinPoint, Object originResult) throws IllegalAccessException, InstantiationException {
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Wrapper wrapperAnnotation = method.getAnnotation(Wrapper.class);
        Class[] baseWrapperClasses = wrapperAnnotation.value();
        if (ObjectUtil.isEmpty((Object)baseWrapperClasses)) {
            return originResult;
        }
        if (!(originResult instanceof ResponseData)) {
            log.warn("\u5f53\u524d\u8bf7\u6c42\u7684\u8fd4\u56de\u7ed3\u679c\u4e0d\u662fResponseData\u7c7b\u578b\uff0c\u76f4\u63a5\u8fd4\u56de\u539f\u503c\uff01");
            return originResult;
        }
        ResponseData responseData = (ResponseData)originResult;
        Object beWrapped = responseData.getData();
        if (ObjectUtil.isBasicType((Object)beWrapped)) {
            throw new WrapperException((AbstractExceptionEnum)WrapperExceptionEnum.BASIC_TYPE_ERROR);
        }
        if (beWrapped instanceof Page) {
            Page page = (Page)beWrapped;
            ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
            for (Object wrappedItem : page.getRecords()) {
                maps.add(this.wrapPureObject(wrappedItem, baseWrapperClasses));
            }
            page.setRecords(maps);
            responseData.setData((Object)page);
        } else if (beWrapped instanceof PageResult) {
            PageResult pageResult = (PageResult)beWrapped;
            ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
            for (Object wrappedItem : pageResult.getRows()) {
                maps.add(this.wrapPureObject(wrappedItem, baseWrapperClasses));
            }
            pageResult.setRows(maps);
            responseData.setData((Object)pageResult);
        } else if (beWrapped instanceof Collection) {
            Collection collection = (Collection)beWrapped;
            ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
            for (Object wrappedItem : collection) {
                maps.add(this.wrapPureObject(wrappedItem, baseWrapperClasses));
            }
            responseData.setData(maps);
        } else if (ArrayUtil.isArray((Object)beWrapped)) {
            Object[] objects = ObjectConvertUtil.objToArray((Object)beWrapped);
            ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
            for (Object wrappedItem : objects) {
                maps.add(this.wrapPureObject(wrappedItem, baseWrapperClasses));
            }
            responseData.setData(maps);
        } else {
            responseData.setData(this.wrapPureObject(beWrapped, baseWrapperClasses));
        }
        return responseData;
    }

    private Map<String, Object> wrapPureObject(Object originModel, Class<? extends BaseWrapper<?>>[] baseWrapperClasses) {
        Map originMap = null;
        try {
            for (Class<BaseWrapper<?>> clazz : baseWrapperClasses) {
                BaseWrapper<?> baseWrapper = clazz.newInstance();
                Map incrementFieldsMap = baseWrapper.doWrap(originModel);
                originMap = BeanUtil.beanToMap((Object)originModel, (String[])new String[0]);
                originMap.putAll(incrementFieldsMap);
            }
        }
        catch (Exception e) {
            log.error("\u539f\u59cb\u5bf9\u8c61\u5305\u88c5\u8fc7\u7a0b\uff0c\u5b57\u6bb5\u8f6c\u5316\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new WrapperException((AbstractExceptionEnum)WrapperExceptionEnum.TRANSFER_ERROR, new Object[]{e.getMessage()});
        }
        return originMap;
    }
}

