/*
 * Decompiled with CFR 0.152.
 */
package cn.suniper.mesh.discovery.provider;

import cn.suniper.mesh.discovery.KVStore;
import cn.suniper.mesh.discovery.exception.NodeNotEmptyException;
import cn.suniper.mesh.discovery.model.Event;
import cn.suniper.mesh.discovery.model.Node;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.Stat;

public class ZKStore
implements KVStore {
    private static Log log = LogFactory.getLog(ZKStore.class);
    private static final String DEFAULT_NODE_VALUE = "";
    private ZooKeeper zooKeeper;

    public ZKStore(ZooKeeper zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public Node get(String key) throws Exception {
        return this.get(key, null);
    }

    public List<Node> list(String prefix) throws Exception {
        List<String> keys = this.listKeys(prefix);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (String key : keys) {
            nodes.add(this.get(key));
        }
        return nodes;
    }

    public List<String> listKeys(String prefix) throws Exception {
        return this.listKeys(prefix, null);
    }

    public long put(String key, String value) throws Exception {
        return this.put(key, value, false);
    }

    public long put(String key, String value, boolean ephemeral) throws Exception {
        Stat stat = this.zooKeeper.exists(key, null);
        if (stat != null) {
            this.zooKeeper.setData(key, value.getBytes(), stat.getVersion());
        } else {
            CreateMode mode = ephemeral ? CreateMode.EPHEMERAL : CreateMode.PERSISTENT;
            this.zooKeeper.create(key, value.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
        }
        stat = this.zooKeeper.exists(key, null);
        log.info((Object)String.format("current stat: %s", stat));
        return stat.getMzxid();
    }

    public long delete(String key) throws Exception {
        Stat stat = this.zooKeeper.exists(key, null);
        if (stat == null) {
            return 0L;
        }
        if (stat.getNumChildren() > 0) {
            throw new NodeNotEmptyException("Node not empty: " + key);
        }
        this.zooKeeper.delete(key, -1);
        return 1L;
    }

    public boolean exists(String key) throws Exception {
        return this.zooKeeper.exists(key, null) != null;
    }

    public void watchChildren(String key, BiConsumer<Event, Node> consumer) throws Exception {
        this.watchChildren(key, null, consumer);
    }

    public void watchChildren(String key, Supplier<Boolean> exitSignSupplier, BiConsumer<Event, Node> consumer) throws Exception {
        List<String> res = this.listKeys(key, new ChildrenWatcher(key, consumer, exitSignSupplier));
        log.debug(res);
    }

    public void createParentNode(String parentNode) throws Exception {
        if (parentNode.equals("/")) {
            return;
        }
        String parentOfParam = ZKStore.getParentName(parentNode);
        if (!this.exists(parentOfParam)) {
            this.createParentNode(parentOfParam);
        }
        this.put(parentNode, DEFAULT_NODE_VALUE);
    }

    static String getParentName(String path) {
        PathUtils.validatePath((String)path);
        if (path.equals("/")) {
            return path;
        }
        return path.substring(0, path.lastIndexOf(47));
    }

    private List<String> listKeys(String prefix, Watcher watcher) throws Exception {
        log.debug((Object)("list keys: " + prefix));
        Stat stat = this.zooKeeper.exists(prefix, watcher);
        if (stat != null) {
            ArrayList<String> keys = new ArrayList<String>();
            this.zooKeeper.getChildren(prefix, watcher).forEach(s -> keys.add(String.join((CharSequence)"/", prefix, s)));
            return keys;
        }
        return Lists.newArrayList();
    }

    private Node get(String key, Watcher watcher) throws Exception {
        try {
            Stat stat = new Stat();
            byte[] data = this.zooKeeper.getData(key, watcher, stat);
            if (data == null) {
                data = new byte[]{};
            }
            return new Node(key, new String(data), stat.getCzxid(), stat.getMzxid(), (long)stat.getVersion());
        }
        catch (KeeperException.NoNodeException e) {
            log.info((Object)String.format("no such node: %s", key));
            log.debug((Object)e);
            return null;
        }
    }

    public void close() throws Exception {
        Optional.ofNullable(this.zooKeeper).ifPresent(z -> {
            try {
                z.close();
            }
            catch (InterruptedException e) {
                log.debug((Object)"close zookeeper client interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
    }

    class SubWatcher
    implements Watcher {
        private BiConsumer<Event, Node> consumer;
        private Supplier<Boolean> exitSignSupplier;
        private volatile boolean stopWatch;

        SubWatcher(BiConsumer<Event, Node> consumer, Supplier<Boolean> exitSignSupplier) {
            this.consumer = consumer;
            this.exitSignSupplier = exitSignSupplier;
        }

        public void process(WatchedEvent event) {
            Node node;
            Event wrapEvent;
            if (this.exitSignSupplier.get().booleanValue()) {
                log.info((Object)("sub-node: stop watch event: " + event));
                return;
            }
            log.debug((Object)("sub-node: watch event: " + event));
            switch (event.getType()) {
                case NodeCreated: 
                case NodeDataChanged: {
                    wrapEvent = Event.UPDATE;
                    try {
                        node = ZKStore.this.get(event.getPath(), this);
                        log.debug((Object)(String.format("get node(%s) data: ", event.getPath()) + node));
                        break;
                    }
                    catch (Throwable throwable) {
                        log.warn((Object)"error occurred in watcher", throwable);
                        return;
                    }
                }
                case NodeDeleted: {
                    wrapEvent = Event.DELETE;
                    node = new Node();
                    node.setKey(event.getPath());
                    break;
                }
                default: {
                    wrapEvent = Event.UNRECOGNIZED;
                    node = new Node();
                    node.setKey(event.getPath());
                }
            }
            this.stopWatch = true;
            this.consumer.accept(wrapEvent, node);
        }

        private SubWatcher activate() {
            this.stopWatch = false;
            return this;
        }
    }

    class ChildrenWatcher
    implements Watcher {
        private final Supplier<Boolean> DEFAULT_SUPPLIER = () -> false;
        private ConcurrentHashMap<String, SubWatcher> childrenWatcher;
        private BiConsumer<Event, Node> consumer;
        private String path;
        private Supplier<Boolean> exitSignSupplier;

        ChildrenWatcher(String path, BiConsumer<Event, Node> consumer, Supplier<Boolean> exitSignSupplier) {
            this.consumer = consumer;
            this.childrenWatcher = new ConcurrentHashMap();
            this.path = path;
            this.exitSignSupplier = exitSignSupplier == null ? this.DEFAULT_SUPPLIER : exitSignSupplier;
            this.listAndWatch(false);
        }

        public void process(WatchedEvent event) {
            log.debug((Object)("parent-node: watch event: " + event));
            if (this.exitSignSupplier.get().booleanValue()) {
                log.info((Object)("parent-node: stop watch event: " + event));
                return;
            }
            switch (event.getType()) {
                case NodeChildrenChanged: {
                    this.listAndWatch(true);
                    return;
                }
            }
            log.debug((Object)"ignore event");
            try {
                List res = ZKStore.this.listKeys(this.path, this);
                log.debug((Object)String.format("Sub nodes of %s: %s", this.path, res));
            }
            catch (Exception e) {
                log.warn((Object)("failed to keep watch node: " + this.path), (Throwable)e);
            }
        }

        private void listAndWatch(boolean accept) {
            try {
                List subList = ZKStore.this.listKeys(this.path, this);
                log.debug((Object)String.format("size of %s: %s", this.path, subList.size()));
                for (String sub : subList) {
                    SubWatcher watcher = this.childrenWatcher.computeIfAbsent(sub, k -> {
                        log.debug((Object)("create new watcher for " + sub));
                        SubWatcher newWatcher = new SubWatcher(this.consumer, this.exitSignSupplier);
                        newWatcher.stopWatch = true;
                        return newWatcher;
                    });
                    if (!watcher.stopWatch) continue;
                    log.debug((Object)("activate watcher for " + sub));
                    watcher.activate();
                    if (accept) {
                        Node node = ZKStore.this.get(sub, watcher);
                        this.consumer.accept(Event.UPDATE, node);
                        continue;
                    }
                    ZKStore.this.zooKeeper.exists(sub, (Watcher)watcher, null, null);
                }
            }
            catch (Exception e) {
                log.warn((Object)("failed to list and watch node: " + this.path), (Throwable)e);
            }
        }
    }
}

