/*
 * Decompiled with CFR 0.152.
 */
package cn.suniper.mesh.transport;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public enum TransportConfigKey {
    GROUP_EVENT_TYPE("plum.tcp.groupEventType", "groupEventType", String.class),
    SOCKET_CHANNEL_TYPE("plum.tcp.socketChannelType", "socketChannelType", String.class),
    WORKERS("plum.tcp.workers", "workers", Integer.TYPE),
    MAX_POOL_CONN("plum.tcp.maxPoolConn", "maxPoolConn", Integer.TYPE),
    CHANNEL_PIPELINES("plum.tcp.channelPipelines", "channelPipelines", List.class);

    private static Map<String, TransportConfigKey> map;
    private String fieldName;
    private Class type;
    private String propName;

    private TransportConfigKey(String propName, String fieldName, Class type) {
        this.propName = propName;
        this.fieldName = fieldName;
        this.type = type;
    }

    public String propName() {
        return this.propName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Class getType() {
        return this.type;
    }

    public static TransportConfigKey get(String fieldName) {
        return map.computeIfAbsent(fieldName, k -> {
            for (TransportConfigKey configKey : TransportConfigKey.values()) {
                if (!configKey.fieldName.equals(k)) continue;
                return configKey;
            }
            return null;
        });
    }

    public Object convert(Object val) {
        if (this.type == String.class) {
            return String.valueOf(val);
        }
        if (this.type == Integer.TYPE || this.type == Integer.class) {
            return Integer.valueOf(String.valueOf(val));
        }
        if (this.type == List.class) {
            if (List.class.isAssignableFrom(val.getClass())) {
                return val;
            }
            if (val.getClass() == String[].class) {
                String[] args = (String[])val;
                return Arrays.asList(args);
            }
            String listStr = String.valueOf(val);
            String[] values = listStr.split(",");
            return Arrays.stream(values).map(String::trim).collect(Collectors.toList());
        }
        return val;
    }

    static {
        map = new ConcurrentHashMap<String, TransportConfigKey>();
    }
}

