/*
 * Decompiled with CFR 0.152.
 */
package cn.suniper.mesh.transport.http;

import cn.suniper.mesh.transport.http.OkHttpResponse;
import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.loadbalancer.ILoadBalancer;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LoadBalancingHttpClient
extends AbstractLoadBalancerAwareClient<HttpRequest, HttpResponse> {
    public static final int DEFAULT_CONNECT_TIMEOUT = 1000;
    public static final int DEFAULT_READ_TIMEOUT = 1000;
    private IClientConfig icc;

    public LoadBalancingHttpClient() {
        this(null);
    }

    public LoadBalancingHttpClient(ILoadBalancer lb) {
        this(lb, null);
    }

    public LoadBalancingHttpClient(ILoadBalancer lb, IClientConfig clientConfig) {
        super(lb, clientConfig);
        this.icc = clientConfig;
        if (this.vipAddresses == null) {
            this.vipAddresses = "LB-APP";
        }
    }

    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(HttpRequest request, IClientConfig requestConfig) {
        if (!request.isRetriable()) {
            return new RequestSpecificRetryHandler(false, false, this.getRetryHandler(), requestConfig);
        }
        if (this.icc != null && ((Boolean)this.icc.get(CommonClientConfigKey.OkToRetryOnAllOperations, (Object)false)).booleanValue()) {
            return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
        }
        if (request.getVerb() != HttpRequest.Verb.GET) {
            return new RequestSpecificRetryHandler(true, false, this.getRetryHandler(), requestConfig);
        }
        return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
    }

    public HttpResponse execute(HttpRequest request, IClientConfig requestConfig) throws Exception {
        IClientConfig overrideConfig;
        IClientConfig iClientConfig = overrideConfig = requestConfig == null ? this.icc : requestConfig;
        if (overrideConfig == null) {
            overrideConfig = new DefaultClientConfigImpl();
        }
        long readTimeout = ((Integer)overrideConfig.get(CommonClientConfigKey.ReadTimeout, (Object)1000)).intValue();
        long connTimeout = ((Integer)overrideConfig.get(CommonClientConfigKey.ConnectTimeout, (Object)1000)).intValue();
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(readTimeout, TimeUnit.MILLISECONDS).connectTimeout(connTimeout, TimeUnit.MILLISECONDS).build();
        String type = request.getHttpHeaders().getFirstValue("Content-Type");
        RequestBody body = null;
        if (request.getEntity() != null) {
            body = RequestBody.create((MediaType)MediaType.parse((String)type), (byte[])((byte[])request.getEntity()));
        }
        Headers.Builder headersBuilder = new Headers.Builder();
        request.getHttpHeaders().getAllHeaders().forEach(e -> headersBuilder.add((String)e.getKey(), (String)e.getValue()));
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(request.getUri().getScheme()).host(request.getUri().getHost()).port(request.getUri().getPort()).addPathSegment(request.getUri().getPath()).query(request.getUri().getQuery());
        request.getQueryParams().entrySet().forEach(e -> {
            for (String v : (Collection)e.getValue()) {
                urlBuilder.addQueryParameter((String)e.getKey(), v);
            }
        });
        Request okRequest = new Request.Builder().method(request.getVerb().verb(), body).url(urlBuilder.build()).headers(headersBuilder.build()).build();
        Response response = client.newCall(okRequest).execute();
        return new OkHttpResponse(response);
    }
}

