/*
 * Decompiled with CFR 0.152.
 */
package cn.suniper.mesh.transport.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import com.netflix.client.ClientException;
import com.netflix.client.http.CaseInsensitiveMultiMap;
import com.netflix.client.http.HttpHeaders;
import com.netflix.client.http.HttpResponse;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import okhttp3.Response;
import okhttp3.ResponseBody;

class OkHttpResponse
implements HttpResponse {
    private Response response;
    private ResponseBody body;

    public OkHttpResponse(Response response) {
        this.response = response;
        this.body = response.body();
    }

    public int getStatus() {
        return this.response.code();
    }

    public String getStatusLine() {
        return this.response.message();
    }

    public Object getPayload() throws ClientException {
        if (this.hasPayload()) {
            return this.body.byteStream();
        }
        return null;
    }

    public boolean hasPayload() {
        return this.body != null;
    }

    public boolean isSuccess() {
        return this.response.isSuccessful();
    }

    public URI getRequestedURI() {
        return this.response.request().url().uri();
    }

    public Map<String, Collection<String>> getHeaders() {
        ArrayListMultimap map = ArrayListMultimap.create();
        this.response.headers().toMultimap().entrySet().forEach(arg_0 -> OkHttpResponse.lambda$getHeaders$0((Multimap)map, arg_0));
        return map.asMap();
    }

    public HttpHeaders getHttpHeaders() {
        CaseInsensitiveMultiMap headers = new CaseInsensitiveMultiMap();
        this.response.headers().toMultimap().entrySet().forEach(entry -> {
            for (String value : (List)entry.getValue()) {
                headers.addHeader((String)entry.getKey(), value);
            }
        });
        return headers;
    }

    public void close() {
        this.response.close();
    }

    public InputStream getInputStream() {
        if (this.body == null) {
            return null;
        }
        return this.body.byteStream();
    }

    public boolean hasEntity() {
        return this.hasPayload();
    }

    public <T> T getEntity(Class<T> type) throws Exception {
        return null;
    }

    public <T> T getEntity(Type type) throws Exception {
        return null;
    }

    public <T> T getEntity(TypeToken<T> type) throws Exception {
        return null;
    }

    private static /* synthetic */ void lambda$getHeaders$0(Multimap map, Map.Entry e) {
        for (String v : (List)e.getValue()) {
            map.put(e.getKey(), (Object)v);
        }
    }
}

