/*
 * Decompiled with CFR 0.152.
 */
package cn.suniper.mesh.transport.tcp;

import cn.suniper.mesh.transport.tcp.AsyncTcpResponse;
import cn.suniper.mesh.transport.tcp.ConnectionPoolManager;
import cn.suniper.mesh.transport.tcp.DefaultPipelineInitializer;
import cn.suniper.mesh.transport.tcp.Initializer;
import cn.suniper.mesh.transport.tcp.TcpRequest;
import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.ILoadBalancer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncLoadBalancingTcpClient
extends AbstractLoadBalancerAwareClient<TcpRequest, AsyncTcpResponse> {
    private static final int BOOTSTRAP_DEFAULT_WORKERS = 2;
    private static final long DEFAULT_TIMEOUT = 5000L;
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private IClientConfig icc;
    private ConnectionPoolManager poolManager;
    private Bootstrap bootstrap;
    private long connectionTimeout = 5000L;

    public AsyncLoadBalancingTcpClient() {
        this(null);
    }

    public AsyncLoadBalancingTcpClient(ILoadBalancer lb) {
        this(lb, null, new DefaultPipelineInitializer());
    }

    public AsyncLoadBalancingTcpClient(ILoadBalancer lb, IClientConfig clientConfig, ConnectionPoolManager poolManager) {
        super(lb, clientConfig);
        this.init(clientConfig);
        this.poolManager = poolManager;
    }

    public AsyncLoadBalancingTcpClient(ILoadBalancer lb, IClientConfig clientConfig, final Initializer initializer) {
        super(lb, clientConfig);
        this.init(clientConfig);
        NioEventLoopGroup group = new NioEventLoopGroup(2);
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                initializer.initChannel((Channel)ch);
            }
        });
    }

    public AsyncLoadBalancingTcpClient(ILoadBalancer lb, IClientConfig clientConfig, Bootstrap bootstrap) {
        super(lb, clientConfig);
        this.init(clientConfig);
        this.bootstrap = bootstrap;
    }

    private void init(IClientConfig clientConfig) {
        this.icc = clientConfig;
        if (this.icc != null) {
            this.connectionTimeout = ((Integer)this.icc.get(IClientConfigKey.Keys.ConnectTimeout)).intValue();
        }
        if (this.vipAddresses == null) {
            this.vipAddresses = "LB-APP";
        }
    }

    public void shutdown() {
        if (this.bootstrap != null) {
            EventLoopGroup group = this.bootstrap.config().group();
            group.shutdownGracefully();
        }
    }

    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(TcpRequest request, IClientConfig requestConfig) {
        if (!request.isRetriable()) {
            return new RequestSpecificRetryHandler(false, false, this.getRetryHandler(), requestConfig);
        }
        if (this.icc != null && ((Boolean)this.icc.get(CommonClientConfigKey.OkToRetryOnAllOperations, (Object)false)).booleanValue()) {
            return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
        }
        return new RequestSpecificRetryHandler(request.isRetriable(), false, this.getRetryHandler(), requestConfig);
    }

    public AsyncTcpResponse execute(TcpRequest request, IClientConfig requestConfig) throws Exception {
        if (this.poolManager == null) {
            return this.executeByBootstrap(request);
        }
        return this.executeByPool(request);
    }

    private AsyncTcpResponse executeByBootstrap(TcpRequest request) throws InterruptedException, ConnectTimeoutException {
        this.log.debug((Object)"execute request via bootstrap");
        InetSocketAddress address = new InetSocketAddress(request.getUri().getHost(), request.getUri().getPort());
        ChannelFuture future = this.bootstrap.connect((SocketAddress)address);
        if (!future.await(this.connectionTimeout, TimeUnit.MILLISECONDS)) {
            throw new ConnectTimeoutException(address.toString());
        }
        Channel channel = future.channel();
        ChannelFuture writeFuture = channel.writeAndFlush(request.getData());
        return new AsyncTcpResponse(writeFuture, request.getUri());
    }

    private AsyncTcpResponse executeByPool(TcpRequest request) throws InterruptedException, ExecutionException, IOException {
        ChannelFuture channelFuture;
        InetSocketAddress address = new InetSocketAddress(request.getUri().getHost(), request.getUri().getPort());
        FixedChannelPool pool = this.poolManager.getChannelPool(address);
        Future future = pool.acquire().sync();
        if (!future.isSuccess()) {
            this.log.debug((Object)future.cause());
            throw new ConnectTimeoutException(String.valueOf(future.cause()));
        }
        Channel channel = (Channel)future.get();
        try {
            channelFuture = channel.writeAndFlush(request.getData());
        }
        catch (Throwable e) {
            pool.release(channel);
            throw new IOException(e);
        }
        return new AsyncTcpResponse(channelFuture, request.getUri(), () -> {
            pool.release(channel);
            return true;
        });
    }
}

