/*
 * Decompiled with CFR 0.152.
 */
package cn.suniper.mesh.transport.tcp;

import com.netflix.client.ClientException;
import com.netflix.client.IResponse;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class AsyncTcpResponse
implements IResponse {
    private URI uri;
    private ChannelFuture channelFuture;
    private ChannelPromise promise;
    private Callable<Boolean> closeAction;

    public AsyncTcpResponse(ChannelFuture future, URI uri) {
        this(future, uri, () -> {
            if (future != null) {
                future.channel().closeFuture();
                return true;
            }
            return false;
        });
    }

    public AsyncTcpResponse(ChannelFuture future, URI uri, Callable<Boolean> closeAction) {
        if (closeAction == null) {
            throw new IllegalArgumentException("Close action must be not null");
        }
        this.channelFuture = future;
        this.uri = uri;
        if (future != null) {
            this.promise = future.channel().newPromise();
            future.addListener(f -> {
                if (f.isSuccess()) {
                    this.promise.setSuccess();
                } else {
                    this.promise.setFailure(f.cause());
                }
            });
        }
        this.closeAction = closeAction;
    }

    public ChannelFuture getPayload() throws ClientException {
        return this.channelFuture;
    }

    public boolean hasPayload() {
        return this.channelFuture != null;
    }

    public boolean isSuccess() {
        return this.promise != null && this.promise.isSuccess();
    }

    public URI getRequestedURI() {
        return this.uri;
    }

    public Map<String, ?> getHeaders() {
        return null;
    }

    public void close() throws IOException {
        try {
            this.closeAction.call();
        }
        catch (Exception e) {
            throw new IOException("close/release channel failed", e);
        }
    }

    public Throwable getCause() {
        return this.promise == null ? null : this.promise.cause();
    }

    public void await() throws InterruptedException {
        if (this.promise != null) {
            this.promise.await();
        }
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.promise.await(time, unit);
    }
}

