/*
 * Decompiled with CFR 0.152.
 */
package cn.suniper.mesh.transport.tcp;

import cn.suniper.mesh.transport.tcp.DefaultPipelineInitializer;
import cn.suniper.mesh.transport.tcp.Initializer;
import cn.suniper.mesh.transport.tcp.NettyClientProperties;
import cn.suniper.mesh.transport.util.PropertiesUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionPoolManager {
    private static Log log = LogFactory.getLog(ConnectionPoolManager.class);
    private static final Class<? extends EventLoopGroup> DEFAULT_GROUP_TYPE = NioEventLoopGroup.class;
    private static final Class DEFAULT_CHANNEL = NioSocketChannel.class;
    private static final int DEFAULT_MAX_CONNECTIONS = 20;
    private static final int DEFAULT_WORKER_THREAD = 4;
    private int maxConn;
    private int nThread;
    private Bootstrap bootstrap;
    private Class<? extends Channel> socketChannelType;
    private Class<? extends EventLoopGroup> groupType;
    private ChannelPoolHandler channelPoolHandler;
    private ChannelPoolMap<InetSocketAddress, FixedChannelPool> poolMap;
    private EventLoopGroup loopGroup;

    private void init() {
        this.groupType = this.groupType == null ? DEFAULT_GROUP_TYPE : this.groupType;
        this.socketChannelType = this.socketChannelType == null ? DEFAULT_CHANNEL : this.socketChannelType;
        this.nThread = this.nThread > 0 ? this.nThread : 4;
        this.maxConn = this.maxConn > 0 ? this.maxConn : 20;
        try {
            this.loopGroup = this.groupType.getConstructor(Integer.TYPE).newInstance(this.nThread);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("No such event group type", e);
        }
        ((Bootstrap)this.bootstrap.group(this.loopGroup)).channel(this.socketChannelType);
        this.poolMap = new AbstractChannelPoolMap<InetSocketAddress, FixedChannelPool>(){

            protected FixedChannelPool newPool(InetSocketAddress key) {
                return new FixedChannelPool(ConnectionPoolManager.this.bootstrap.remoteAddress((SocketAddress)key), ConnectionPoolManager.this.channelPoolHandler, ConnectionPoolManager.this.maxConn);
            }
        };
    }

    public FixedChannelPool getChannelPool(InetSocketAddress address) {
        if (this.poolMap == null) {
            return null;
        }
        return (FixedChannelPool)this.poolMap.get((Object)address);
    }

    public void shutdown() {
        if (this.loopGroup != null) {
            this.loopGroup.shutdownGracefully();
        }
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public void setMaxConn(int maxConn) {
        this.maxConn = maxConn;
    }

    public int getnThread() {
        return this.nThread;
    }

    public void setnThread(int nThread) {
        this.nThread = nThread;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public Class<? extends Channel> getSocketChannelType() {
        return this.socketChannelType;
    }

    public void setSocketChannelType(Class<? extends Channel> socketChannelType) {
        this.socketChannelType = socketChannelType;
    }

    public Class<? extends EventLoopGroup> getGroupType() {
        return this.groupType;
    }

    public void setGroupType(Class<? extends EventLoopGroup> groupType) {
        this.groupType = groupType;
    }

    public ChannelPoolHandler getChannelPoolHandler() {
        return this.channelPoolHandler;
    }

    public void setChannelPoolHandler(ChannelPoolHandler channelPoolHandler) {
        this.channelPoolHandler = channelPoolHandler;
    }

    public static ConnectionPoolManager initFromClientProperties(Properties properties) throws ClassNotFoundException {
        NettyClientProperties tcpClientProperties = PropertiesUtil.getClientPropFromProperties(properties);
        return ConnectionPoolManager.initFromClientProperties(tcpClientProperties);
    }

    public static ConnectionPoolManager initFromClientProperties(NettyClientProperties properties, Initializer initializer) throws ClassNotFoundException {
        if (initializer == null) {
            throw new IllegalArgumentException("Pipeline initializer must be not null");
        }
        Class<?> groupEventType = null;
        if (properties.getGroupEventType() != null) {
            groupEventType = Class.forName(properties.getGroupEventType());
        }
        Class<?> socketChannelType = null;
        if (properties.getSocketChannelType() != null) {
            socketChannelType = Class.forName(properties.getSocketChannelType());
        }
        Bootstrap bootstrap = (Bootstrap)new Bootstrap().option(ChannelOption.SO_KEEPALIVE, (Object)true);
        return new Builder(bootstrap).setWorkerThread(properties.getWorkers()).setMaxConn(properties.getMaxPoolConn()).setGroupType(groupEventType).setSocketChannelType(socketChannelType).setChannelPoolHandler(new DefaultChannelPoolHandler(initializer)).build();
    }

    public static ConnectionPoolManager initFromClientProperties(NettyClientProperties properties) throws ClassNotFoundException {
        DefaultPipelineInitializer pipelineInitializer = new DefaultPipelineInitializer(properties.getChannelPipelines());
        return ConnectionPoolManager.initFromClientProperties(properties, pipelineInitializer);
    }

    private static class DefaultChannelPoolHandler
    implements ChannelPoolHandler {
        private Initializer initializer;

        DefaultChannelPoolHandler(Initializer initializer) {
            this.initializer = initializer;
        }

        public void channelReleased(Channel ch) throws Exception {
            log.info((Object)String.format("channel released, is open: %s, is active: %s, is registered: %s, is writable: %s", ch.isOpen(), ch.isActive(), ch.isRegistered(), ch.isWritable()));
        }

        public void channelAcquired(Channel ch) throws Exception {
            log.info((Object)String.format("channel acquired, is open: %s, is active: %s, is registered: %s, is writable: %s", ch.isOpen(), ch.isActive(), ch.isRegistered(), ch.isWritable()));
        }

        public void channelCreated(Channel ch) throws Exception {
            log.info((Object)String.format("channel created, is open: %s, is active: %s, is registered: %s, is writable: %s", ch.isOpen(), ch.isActive(), ch.isRegistered(), ch.isWritable()));
            this.initializer.initChannel(ch);
        }
    }

    public static class Builder {
        private ConnectionPoolManager poolManager = new ConnectionPoolManager();

        public Builder(Bootstrap bootstrap) {
            this.poolManager.bootstrap = bootstrap;
        }

        public Builder setGroupType(Class<? extends EventLoopGroup> groupType) {
            this.poolManager.groupType = groupType;
            return this;
        }

        public Builder setSocketChannelType(Class<? extends Channel> socketChannelType) {
            this.poolManager.socketChannelType = socketChannelType;
            return this;
        }

        public Builder setMaxConn(int maxConn) {
            this.poolManager.maxConn = maxConn;
            return this;
        }

        public Builder setWorkerThread(int nThread) {
            this.poolManager.nThread = nThread;
            return this;
        }

        public Builder setChannelPoolHandler(ChannelPoolHandler channelPoolHandler) {
            this.poolManager.channelPoolHandler = channelPoolHandler;
            return this;
        }

        public ConnectionPoolManager build() {
            this.poolManager.init();
            return this.poolManager;
        }
    }
}

