/*
 * Decompiled with CFR 0.152.
 */
package cn.suniper.mesh.transport.tcp;

import cn.suniper.mesh.transport.tcp.Initializer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.ArrayList;
import java.util.List;

public class DefaultPipelineInitializer
implements Initializer {
    private List<Class<? extends ChannelHandler>> channelHandlers = new ArrayList<Class<? extends ChannelHandler>>();

    public DefaultPipelineInitializer() {
    }

    public DefaultPipelineInitializer(List<String> handlerList) throws ClassNotFoundException {
        for (String handlerClassName : handlerList) {
            Class<?> handlerClass = Class.forName(handlerClassName);
            this.channelHandlers.add(handlerClass);
        }
    }

    public void setChannelHandlers(List<Class<? extends ChannelHandler>> channelHandlers) {
        this.channelHandlers = channelHandlers;
    }

    @Override
    public void initChannel(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        for (Class<? extends ChannelHandler> handlerClass : this.channelHandlers) {
            ChannelHandler handler = handlerClass.newInstance();
            pipeline.addLast(new ChannelHandler[]{handler});
        }
    }
}

