/*
 * Decompiled with CFR 0.152.
 */
package cn.suniper.mesh.transport.util;

import cn.suniper.mesh.transport.TransportConfigKey;
import cn.suniper.mesh.transport.tcp.NettyClientProperties;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesUtil {
    private static Log log = LogFactory.getLog(PropertiesUtil.class);

    public static NettyClientProperties getClientPropFromProperties(Properties properties) {
        BeanInfo beanInfo;
        NettyClientProperties tcpClientProperties = new NettyClientProperties();
        try {
            beanInfo = Introspector.getBeanInfo(NettyClientProperties.class);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            if (descriptor.getName().equals("class")) continue;
            TransportConfigKey key = TransportConfigKey.get(descriptor.getName());
            Optional.ofNullable(key).map(k -> {
                Object val = properties.get(k.propName());
                return val != null ? k.convert(val) : null;
            }).ifPresent(v -> {
                Method setter = descriptor.getWriteMethod();
                try {
                    setter.invoke((Object)tcpClientProperties, v);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.debug((Object)e);
                    throw new IllegalArgumentException("illegal property value");
                }
            });
        }
        return tcpClientProperties;
    }
}

